/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.CompositeErrorMatcher;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.DefaultErrorMatcher;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;

public class ErrorHandlingUtils {
    private static final String ERROR_CLASS = "org.mule.runtime.api.message.Error";

    public static Optional<ErrorModel> createErrorModel(String error) {
        return ErrorHandlingUtils.createErrorCode(error).map(errorCode -> ErrorModelBuilder.newError((String)errorCode.getLocalPart(), (String)errorCode.getNamespaceURI()).build());
    }

    public static Optional<QName> createErrorCode(String errorCode) {
        if (errorCode == null || errorCode.isEmpty()) {
            return Optional.empty();
        }
        errorCode = errorCode.trim();
        String namespace = null;
        String name = null;
        String[] split = errorCode.split(":");
        switch (split.length) {
            case 1: {
                name = split[0];
                break;
            }
            case 2: {
                namespace = split[0];
                name = split[1];
            }
        }
        if (name != null) {
            return Optional.of(namespace != null ? new QName(namespace, name) : new QName(name));
        }
        return Optional.empty();
    }

    public static List<QName> getErrorCodes(ErrorModel unhandledError) {
        ArrayList<QName> catchableErrorCodes = new ArrayList<QName>();
        ErrorModel currentErrorModel = unhandledError;
        while (currentErrorModel != null) {
            catchableErrorCodes.add(new QName(currentErrorModel.getNamespace(), currentErrorModel.getType()));
            currentErrorModel = currentErrorModel.getParent().orElse(null);
        }
        return catchableErrorCodes;
    }

    public static ErrorMatcher createErrorMatcher(String errorMatchExpression) {
        String[] errorCodes = errorMatchExpression.split(",");
        List<ErrorMatcher> errorMatchers = Arrays.stream(errorCodes).map(errorCode -> new DefaultErrorMatcher(errorCode.trim())).collect(Collectors.toList());
        return new CompositeErrorMatcher(errorMatchers);
    }

    private static Set<QName> getErrorCodes(Set<ErrorModel> errorModels) {
        LinkedHashSet<QName> result = new LinkedHashSet<QName>();
        errorModels.forEach(errorModel -> {
            if (errorModel.isHandleable()) {
                result.addAll(ErrorHandlingUtils.getErrorCodes(errorModel));
            }
        });
        return result;
    }

    public static MetadataType errorType() {
        return ErrorTypeHolder.singleton;
    }

    public static MetadataType errorType(Set<ErrorModel> unhandledErrors) {
        BaseTypeBuilder errorTypeBuilder = TypesHelper.getTypeBuilder();
        Set<QName> errorCodes = ErrorHandlingUtils.getErrorCodes(unhandledErrors);
        ArrayList namespaces = new ArrayList();
        ArrayList identifiers = new ArrayList();
        errorCodes.forEach(errorCode -> {
            namespaces.add(errorCode.getNamespaceURI());
            identifiers.add(errorCode.getLocalPart());
        });
        ObjectTypeBuilder typeBuilder = errorTypeBuilder.objectType();
        typeBuilder.addField().key("description").value().stringType();
        typeBuilder.addField().key("detailedDescription").value().stringType();
        ObjectTypeBuilder errorType = typeBuilder.addField().key("errorType").value().objectType();
        errorType.addField().key("namespace").value().stringType().enumOf(namespaces.toArray(new String[namespaces.size()]));
        errorType.addField().key("identifier").value().stringType().enumOf(identifiers.toArray(new String[identifiers.size()]));
        return errorTypeBuilder.build();
    }

    private static class ErrorTypeHolder {
        private static final MetadataType singleton = TypesHelper.getTypeFromJavaClass("org.mule.runtime.api.message.Error", GlobalBindingMetadataTypes.class.getClassLoader()).orElse(ErrorHandlingUtils.errorType(Collections.EMPTY_SET));

        private ErrorTypeHolder() {
        }
    }
}

