/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class ComponentModelUtils {
    public static Optional<Stream<ComponentModel>> collectComponentModels(MessageProcessorNode messageProcessorNode, Predicate<? super ComponentModel> childComponentFilter) {
        if (messageProcessorNode == null) {
            return Optional.empty();
        }
        ComponentModel componentModel = messageProcessorNode.getComponentModel();
        if (componentModel == null) {
            return Optional.empty();
        }
        return Optional.of(componentModel.getInnerComponents().stream().filter(childComponentFilter));
    }

    public static Optional<Stream<ComponentModel>> collectComponentModelsById(MessageProcessorNode messageProcessorNode, ComponentIdentifier componentIdentifier) {
        if (componentIdentifier == null) {
            return Optional.empty();
        }
        return ComponentModelUtils.collectComponentModels(messageProcessorNode, componentModel -> componentIdentifier.equals(ComponentIdentifierUtils.createFromComponentModel(componentModel)));
    }

    public static Optional<ComponentModel> collectComponentModelById(MessageProcessorNode messageProcessorNode, ComponentIdentifier componentIdentifier) {
        return ComponentModelUtils.collectComponentModelsById(messageProcessorNode, componentIdentifier).flatMap(Stream::findFirst);
    }
}

