/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

public class MessageProcessorNodeTest {
    @Mock
    private ComponentIdentifier mockComponentIdentifier;
    @Mock
    private ComponentAst mockComponentModel;
    @Mock
    private FunctionType mockDeclaredFunctionType;
    @Mock
    private ComponentLocation mockComponentLocation;
    @Mock
    private AstNodeVisitor<Object> mockAstNodeVisitor;
    private List<MessageProcessorNode> messageProcessorNodeList;
    private MessageProcessorNode messageProcessorNode;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.messageProcessorNodeList = new ArrayList<MessageProcessorNode>();
        Mockito.when((Object)this.mockComponentIdentifier.toString()).thenReturn((Object)"TestIdentifier");
        Mockito.when((Object)this.mockComponentModel.getLocation()).thenReturn((Object)this.mockComponentLocation);
    }

    @Test
    public void testConstructorWithAllParameters() {
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList, this.mockDeclaredFunctionType, ComponentModelType.MESSAGE_PROCESSOR_NODE, false);
        Assert.assertEquals((Object)"TestIdentifier", (Object)this.messageProcessorNode.getName());
        Assert.assertFalse((boolean)this.messageProcessorNode.isSynthetic());
        Assert.assertEquals((Object)this.mockComponentIdentifier, (Object)this.messageProcessorNode.getComponentIdentifier());
        Assert.assertEquals((Object)this.mockComponentModel, (Object)this.messageProcessorNode.getComponentModel());
        Assert.assertEquals(Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE), (Object)this.messageProcessorNode.getComponentModelType());
        Assert.assertNotNull((Object)this.messageProcessorNode.getAstNodeLocation());
    }

    @Test
    public void testConstructorWithSyntheticParameter() {
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList, true);
        Assert.assertTrue((boolean)this.messageProcessorNode.isSynthetic());
    }

    @Test
    public void testSetAndGetParentAstNode() {
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList);
        AstNode mockParentNode = (AstNode)Mockito.mock(AstNode.class);
        this.messageProcessorNode.setParentAstNode(mockParentNode);
        Assert.assertEquals((Object)mockParentNode, (Object)this.messageProcessorNode.getParentAstNode());
    }

    @Test
    public void testSetAndGetRootMessageProcessorNode() {
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList);
        Assert.assertFalse((boolean)this.messageProcessorNode.isRootMessageProcessorNode());
        this.messageProcessorNode.setRootMessageProcessorNode(true);
        Assert.assertTrue((boolean)this.messageProcessorNode.isRootMessageProcessorNode());
    }

    @Test
    public void testGetMessageProcessorNodes() {
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.messageProcessorNodeList.add(childNode);
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList);
        Assert.assertEquals((long)1L, (long)this.messageProcessorNode.getMessageProcessorNodes().count());
        Assert.assertEquals((Object)childNode, this.messageProcessorNode.getMessageProcessorNodes().findFirst().get());
    }

    @Test
    public void testAccept() {
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList);
        Object context = new Object();
        Object expectedResult = new Object();
        Mockito.when((Object)this.mockAstNodeVisitor.visit(this.messageProcessorNode, context)).thenReturn(expectedResult);
        Object result = this.messageProcessorNode.accept(this.mockAstNodeVisitor, context);
        Assert.assertEquals((Object)expectedResult, (Object)result);
        ((AstNodeVisitor)Mockito.verify(this.mockAstNodeVisitor)).visit(this.messageProcessorNode, context);
    }

    @Test
    public void testConstructorWithNullComponentLocation() {
        Mockito.when((Object)this.mockComponentModel.getLocation()).thenReturn(null);
        this.messageProcessorNode = new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, this.messageProcessorNodeList);
        Assert.assertNull((Object)this.messageProcessorNode.getAstNodeLocation());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullComponentIdentifier() {
        new MessageProcessorNode(null, this.mockComponentModel, this.messageProcessorNodeList);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullMessageProcessorNodeList() {
        new MessageProcessorNode(this.mockComponentIdentifier, this.mockComponentModel, null);
    }
}

