/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.ast2.test.utils;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.datasense.impl.util.AnnotationSupport;

public class AnnotationSupportTest {
    private AnnotationSupport<MyAnnotation> annotationSupport;

    @Before
    public void init() {
        this.annotationSupport = new AnnotationSupport();
    }

    @Test
    public void annotateStoresAnnotations() {
        AnAnnotation anAnnotation = new AnAnnotation("a");
        this.annotationSupport.annotate((Object)anAnnotation);
        Assert.assertTrue((this.annotationSupport.getAnnotations().size() == 1 ? 1 : 0) != 0);
        Optional optionalAnnotation = this.annotationSupport.getAnnotation(AnAnnotation.class);
        Assert.assertTrue((boolean)optionalAnnotation.isPresent());
        Assert.assertEquals((Object)anAnnotation, optionalAnnotation.get());
    }

    @Test
    public void annotateOverrideAPreviousAnnotation() {
        AnAnnotation anAnnotation1 = new AnAnnotation("1");
        AnAnnotation anAnnotation2 = new AnAnnotation("2");
        this.annotationSupport.annotate((Object)anAnnotation1);
        this.annotationSupport.annotate((Object)anAnnotation2);
        Assert.assertTrue((this.annotationSupport.getAnnotations().size() == 1 ? 1 : 0) != 0);
        Optional optionalAnnotation = this.annotationSupport.getAnnotation(AnAnnotation.class);
        Assert.assertTrue((boolean)optionalAnnotation.isPresent());
        Assert.assertEquals((Object)anAnnotation2, optionalAnnotation.get());
    }

    @Test
    public void annotateRetrievableOnlyByAnnotationClass() {
        AnAnnotationExtension anAnnotationExtension = new AnAnnotationExtension("1");
        this.annotationSupport.annotate((Object)anAnnotationExtension);
        Assert.assertFalse((boolean)this.annotationSupport.getAnnotation(AnAnnotation.class).isPresent());
        Assert.assertTrue((boolean)this.annotationSupport.getAnnotation(AnAnnotationExtension.class).isPresent());
    }

    @Test
    public void deannotateRemoveAnnotation() {
        AnAnnotation anAnnotation = new AnAnnotation("1");
        this.annotationSupport.annotate((Object)anAnnotation);
        Assert.assertTrue((boolean)this.annotationSupport.getAnnotation(AnAnnotation.class).isPresent());
        this.annotationSupport.deannotate(AnAnnotation.class);
        Assert.assertFalse((boolean)this.annotationSupport.getAnnotation(AnAnnotation.class).isPresent());
    }

    @Test
    public void isAnnotatedWithChecksAnnotationPresence() {
        AnAnnotation anAnnotation = new AnAnnotation("1");
        this.annotationSupport.annotate((Object)anAnnotation);
        Assert.assertTrue((boolean)this.annotationSupport.isAnnotatedWith(AnAnnotation.class));
        this.annotationSupport.deannotate(AnAnnotation.class);
        Assert.assertFalse((boolean)this.annotationSupport.isAnnotatedWith(AnAnnotation.class));
    }

    static class AnAnnotation
    implements MyAnnotation {
        final String string;

        public AnAnnotation(String string) {
            this.string = string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnAnnotation that = (AnAnnotation)o;
            return this.string.equals(that.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }
    }

    static class AnAnnotationExtension
    extends AnAnnotation {
        public AnAnnotationExtension(String string) {
            super(string);
        }
    }

    static class AnotherAnnotation
    implements MyAnnotation {
        final String string;

        public AnotherAnnotation(String string) {
            this.string = string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnAnnotation that = (AnAnnotation)o;
            return this.string.equals(that.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }
    }

    static interface MyAnnotation {
    }
}

