/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.annotations.munit;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclarationsAnnotation;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;

public class MUnitDeclarationsAnnotationTest {
    private MUnitDeclarationsAnnotation annotation;
    @Mock
    private MuleFlowNode mockMuleFlowNode;
    @Mock
    private ComponentAst mockComponentModel;
    @Mock
    private ComponentMetadataAst mockMetadata;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.annotation = new MUnitDeclarationsAnnotation();
        Mockito.when((Object)this.mockMuleFlowNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.getMetadata()).thenReturn((Object)this.mockMetadata);
        Mockito.when((Object)this.mockMetadata.getFileName()).thenReturn(Optional.of("testFile.xml"));
    }

    @Test
    public void testSetAndGetBeforeTestMuleFlowNode() {
        this.annotation.setBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        Optional result = this.annotation.getBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockMuleFlowNode, result.get());
    }

    @Test
    public void testSetAndGetAfterTestMuleFlowNode() {
        this.annotation.setAfterTestMuleFlowNode(this.mockMuleFlowNode);
        Optional result = this.annotation.getAfterTestMuleFlowNode(this.mockMuleFlowNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockMuleFlowNode, result.get());
    }

    @Test
    public void testSetAndGetBeforeSuiteMuleFlowNode() {
        this.annotation.setBeforeSuiteMuleFlowNode(this.mockMuleFlowNode);
        Optional result = this.annotation.getBeforeSuiteMuleFlowNode(this.mockMuleFlowNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockMuleFlowNode, result.get());
    }

    @Test
    public void testSetAndGetAfterSuiteMuleFlowNode() {
        this.annotation.setAfterSuiteMuleFlowNode(this.mockMuleFlowNode);
        Optional result = this.annotation.getAfterSuiteMuleFlowNode(this.mockMuleFlowNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockMuleFlowNode, result.get());
    }

    @Test
    public void testGetNonExistentNode() {
        Optional result = this.annotation.getBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testMultipleNodesWithDifferentFiles() {
        MuleFlowNode mockMuleFlowNode2 = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)mockMuleFlowNode2.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)mockMuleFlowNode2.getComponentModel().getMetadata()).thenReturn((Object)((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)));
        Mockito.when((Object)mockMuleFlowNode2.getComponentModel().getMetadata().getFileName()).thenReturn(Optional.of("testFile2.xml"));
        this.annotation.setBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        this.annotation.setBeforeTestMuleFlowNode(mockMuleFlowNode2);
        Optional result1 = this.annotation.getBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        Optional result2 = this.annotation.getBeforeTestMuleFlowNode(mockMuleFlowNode2);
        Assert.assertTrue((boolean)result1.isPresent());
        Assert.assertTrue((boolean)result2.isPresent());
        Assert.assertEquals((Object)this.mockMuleFlowNode, result1.get());
        Assert.assertEquals((Object)mockMuleFlowNode2, result2.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetKeyWithNoFileName() {
        Mockito.when((Object)this.mockMetadata.getFileName()).thenReturn(Optional.empty());
        this.annotation.setBeforeTestMuleFlowNode(this.mockMuleFlowNode);
    }

    @Test
    public void testOverwriteExistingNode() {
        MuleFlowNode newMockMuleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)newMockMuleFlowNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        this.annotation.setBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        this.annotation.setBeforeTestMuleFlowNode(newMockMuleFlowNode);
        Optional result = this.annotation.getBeforeTestMuleFlowNode(this.mockMuleFlowNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)newMockMuleFlowNode, result.get());
    }
}

