/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.MuleEventExprAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExpr;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.phases.annotators.TransformAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.transform.TransformParser;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class TransformAnnotatorTest {
    private TransformAnnotator transformAnnotator;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext;
    @Mock
    private ComponentAst componentModel;
    @Mock
    private TransformParser transformParser;
    @Mock
    private MuleEventExprBuilder muleEventExprBuilder;
    @Mock
    private MuleEventExpr muleEventExpr;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.transformAnnotator = new TransformAnnotator();
        try {
            Field field = TransformAnnotator.class.getDeclaredField("transformParser");
            field.setAccessible(true);
            field.set(this.transformAnnotator, this.transformParser);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set mocked TransformParser", e);
        }
    }

    @Test
    public void testAnnotateWithTransformComponent() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_TRANSFORM);
        Mockito.when((Object)this.transformParser.parse((ComponentAst)Mockito.eq((Object)this.componentModel), (Function)Mockito.any(), (AstNotification)Mockito.any(), (AstNodeLocation)Mockito.any())).thenReturn((Object)this.muleEventExprBuilder);
        Mockito.when((Object)this.muleEventExprBuilder.build()).thenReturn((Object)this.muleEventExpr);
        Mockito.when((Object)this.annotatingMuleAstVisitorContext.getDataSenseProviderResolver()).thenReturn((Object)((DataSenseProviderResolver)Mockito.mock(DataSenseProviderResolver.class)));
        this.transformAnnotator.annotate(this.messageProcessorNode, this.annotatingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((MuleEventExprAnnotation)Mockito.any(MuleEventExprAnnotation.class)));
        ((TransformParser)Mockito.verify((Object)this.transformParser)).parse((ComponentAst)Mockito.eq((Object)this.componentModel), (Function)Mockito.any(), (AstNotification)Mockito.any(), (AstNodeLocation)Mockito.any());
        ((MuleEventExprBuilder)Mockito.verify((Object)this.muleEventExprBuilder)).build();
    }

    @Test
    public void testAnnotateWithNonTransformComponent() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)));
        this.transformAnnotator.annotate(this.messageProcessorNode, this.annotatingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((MuleEventExprAnnotation)Mockito.any(MuleEventExprAnnotation.class)));
        ((TransformParser)Mockito.verify((Object)this.transformParser, (VerificationMode)Mockito.never())).parse((ComponentAst)Mockito.any(), (Function)Mockito.any(), (AstNotification)Mockito.any(), (AstNodeLocation)Mockito.any());
    }

    @Test
    public void testAnnotateWithNullComponentModel() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        this.transformAnnotator.annotate(this.messageProcessorNode, this.annotatingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((MuleEventExprAnnotation)Mockito.any(MuleEventExprAnnotation.class)));
        ((TransformParser)Mockito.verify((Object)this.transformParser, (VerificationMode)Mockito.never())).parse((ComponentAst)Mockito.any(), (Function)Mockito.any(), (AstNotification)Mockito.any(), (AstNodeLocation)Mockito.any());
    }
}

