/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.UnknownTypeResolverAnnotator;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessage;

public class UnknownTypeResolverAnnotatorTest {
    private UnknownTypeResolverAnnotator annotator;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private AnnotatingMuleAstVisitorContext context;
    @Mock
    private AstNotification astNotification;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.annotator = new UnknownTypeResolverAnnotator();
        Mockito.when((Object)this.context.getAstNotification()).thenReturn((Object)this.astNotification);
    }

    @Test
    public void testAnnotateRootMessageProcessorNode() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)true);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getAnnotation(TypeResolverAnnotation.class);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getComponentModelType();
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
        ((AstNotification)Mockito.verify((Object)this.astNotification, (VerificationMode)Mockito.never())).reportWarning((AstNodeLocation)Mockito.any(), (I18nMessage)Mockito.any());
    }

    @Test
    public void testAnnotateWithExistingTypeResolverAnnotation() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.of((TypeResolverAnnotation)Mockito.mock(TypeResolverAnnotation.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getComponentModelType();
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
        ((AstNotification)Mockito.verify((Object)this.astNotification, (VerificationMode)Mockito.never())).reportWarning((AstNodeLocation)Mockito.any(), (I18nMessage)Mockito.any());
    }

    @Test
    public void testAnnotateWithoutComponentModelType() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getComponentModelType()).thenReturn(Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Assert.assertNotNull((Object)this.annotator);
    }
}

