/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.MessageProcessorScope;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.CollectionSplitterTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class CollectionSplitterTypeResolverTest {
    static final transient Logger logger = LoggerFactory.getLogger(CollectionSplitterTypeResolverTest.class);
    private final String name;
    private final Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier;
    private final String usesMetadataTypeData;
    private final String definesMetadataTypeData;
    private final String resultMetadataTypeData;
    private final MessageProcessorNode messageProcessorNode;
    private final CollectionSplitterTypeResolver collectionSplitterTypeResolver;
    private final TypeResolverRegistry typeResolverRegistry;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService = ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService();

    public CollectionSplitterTypeResolverTest(String name, Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier, String usesMetadataTypeData, String definesMetadataTypeData, String resultMetadataTypeData) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(inputMuleEventMetadataTypeBuilderSupplier);
        Preconditions.checkNotNull((Object)usesMetadataTypeData);
        Preconditions.checkNotNull((Object)definesMetadataTypeData);
        Preconditions.checkNotNull((Object)resultMetadataTypeData);
        this.name = name;
        this.inputMuleEventMetadataTypeBuilderSupplier = inputMuleEventMetadataTypeBuilderSupplier;
        this.usesMetadataTypeData = usesMetadataTypeData;
        this.definesMetadataTypeData = definesMetadataTypeData;
        this.resultMetadataTypeData = resultMetadataTypeData;
        this.typeResolverRegistry = new TypeResolverRegistry();
        this.messageProcessorNode = new MessageProcessorNode(ComponentIdentifier.buildFromStringRepresentation((String)"collection-splitter"), null, Collections.emptyList());
        this.collectionSplitterTypeResolver = new CollectionSplitterTypeResolver();
    }

    private static List<Object[]> collectionSplittingArrays() {
        return Arrays.asList({"collectionSplittingArrayOfStringGivesString", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().arrayType().of().stringType();
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : [String]\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"collectionSplittingArrayOfStringWithAttributesAndVarGivesStringAndPropagates", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().arrayType().of().stringType();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            muleEventMetadataTypeBuilder.addVariable("v1", (MetadataType)TypesHelper.getTypeBuilder().stringType().build());
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : [String], \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"}, {"collectionSplittingArrayOfObjectGivesThatObject", () -> {
            ObjectTypeBuilder objectTypeBuilder = TypesHelper.getTypeBuilder().objectType();
            objectTypeBuilder.addField().key("f1").required(true).value().stringType();
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().arrayType().of((TypeBuilder)objectTypeBuilder);
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : [{\n        \"f1\" : String\n      }]\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : {\n      \"f1\" : String\n    }\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : {\n      \"f1\" : String\n    }\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"collectionSplittingArrayOfObjectWithAttributesAndVarGivesThatObjectAndPropagates", () -> {
            ObjectTypeBuilder objectTypeBuilder = TypesHelper.getTypeBuilder().objectType();
            objectTypeBuilder.addField().key("f1").required(true).value().stringType();
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().arrayType().of((TypeBuilder)objectTypeBuilder);
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            muleEventMetadataTypeBuilder.addVariable("v1", (MetadataType)TypesHelper.getTypeBuilder().stringType().build());
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : [{\n        \"f1\" : String\n      }], \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : {\n      \"f1\" : String\n    }, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : {\n      \"f1\" : String\n    }, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"});
    }

    private static List<Object[]> collectionSplittingNonArrays() {
        return Arrays.asList({"collectionSplittingStringGivesAny", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"collectionSplittingStringWithAttributesAndVarGivesAnyAndPropagates", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            muleEventMetadataTypeBuilder.addVariable("v1", (MetadataType)TypesHelper.getTypeBuilder().stringType().build());
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"}, {"collectionSplittingNumberGivesAny", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().numberType();
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Number\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"collectionSplittingNumberWithAttributesAndVarGivesAnyAndPropagates", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().numberType();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            muleEventMetadataTypeBuilder.addVariable("v1", (MetadataType)TypesHelper.getTypeBuilder().stringType().build());
            return muleEventMetadataTypeBuilder;
        }, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Number, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : Any, \n    \"attributes\" : String\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"});
    }

    @Parameterized.Parameters(name="{0}-{index}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(CollectionSplitterTypeResolverTest.collectionSplittingArrays());
        parameters.addAll(CollectionSplitterTypeResolverTest.collectionSplittingNonArrays());
        return parameters;
    }

    private void assertMetadataType(String label, EventType eventType, String expectedMetadataTypeData) {
        MuleEventMetadataType actualMetadataType = TypeUtils.asMuleEventMetadataType((EventType)eventType).build();
        Assert.assertThat((String)String.format("Assertion failed for %s metadata type.", label), (Object)actualMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(expectedMetadataTypeData));
    }

    @Test
    public void test() {
        TypingMuleAstVisitorContext typingMuleAstVisitorContext = new TypingMuleAstVisitorContext(this.typeResolverRegistry, new AstNotification(), this.expressionLanguageMetadataService);
        EventType inputEventType = TypeUtils.asEventType((MuleEventMetadataType)((MuleEventMetadataTypeBuilder)this.inputMuleEventMetadataTypeBuilderSupplier.get()).build());
        TypingMuleAstVisitor typingMuleAstVisitor = new TypingMuleAstVisitor(this.typeResolverRegistry, this.expressionLanguageMetadataService);
        typingMuleAstVisitorContext.getTypingEnvironment().push(new MessageProcessorScope(inputEventType));
        EventType resultEventType = this.collectionSplitterTypeResolver.resolveTypes(this.messageProcessorNode, typingMuleAstVisitor, typingMuleAstVisitorContext);
        UsesTypeAnnotation usesTypeAnnotation = (UsesTypeAnnotation)this.messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).orElseThrow(AssertionError::new);
        EventType usesEventType = usesTypeAnnotation.getUsesEventType();
        this.assertMetadataType("USES", usesEventType, this.usesMetadataTypeData);
        DefinesTypeAnnotation definesTypeAnnotation = (DefinesTypeAnnotation)this.messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).orElseThrow(AssertionError::new);
        EventType definesEventType = definesTypeAnnotation.getDefinesEventType();
        this.assertMetadataType("DEFINES", definesEventType, this.definesMetadataTypeData);
        this.assertMetadataType("RESULT", resultEventType, this.resultMetadataTypeData);
    }
}

