/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.FlowRefTypeResolver;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class FlowRefTypeResolverTest {
    private FlowRefTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext visitorContext;
    private MuleApplicationNode muleApplicationNode;
    private ComponentAst componentModel;
    private ComponentParameterAst parameterAst;

    @Before
    public void setUp() {
        this.resolver = new FlowRefTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.visitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        this.muleApplicationNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        this.componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.parameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.componentModel.getParameter("General", "name")).thenReturn((Object)this.parameterAst);
        Mockito.when((Object)this.visitorContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(new MuleApplicationAnnotation(this.muleApplicationNode)));
    }

    @Test
    public void testGetComponentModelType() {
        Assert.assertEquals(Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE), (Object)this.resolver.getComponentModelType());
    }

    @Test
    public void testResolveWithExistingFlow() {
        String referredFlowName = "testFlow";
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        EventType expectedEventType = new EventType();
        DefinesTypeAnnotation definesTypeAnnotation = new DefinesTypeAnnotation(expectedEventType);
        Mockito.when((Object)this.parameterAst.getResolvedRawValue()).thenReturn((Object)referredFlowName);
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode(referredFlowName)).thenReturn(Optional.of(muleFlowNode));
        Mockito.when((Object)muleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.of(definesTypeAnnotation));
        try {
            EventType eventType = this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testResolveWithNonExistingFlow() {
        String referredFlowName = "nonExistingFlow";
        AstNotification astNotification = (AstNotification)Mockito.mock(AstNotification.class);
        Mockito.when((Object)this.parameterAst.getResolvedRawValue()).thenReturn((Object)referredFlowName);
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode(referredFlowName)).thenReturn(Optional.empty());
        Mockito.when((Object)this.visitorContext.getAstNotification()).thenReturn((Object)astNotification);
        try {
            this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testResolveWithInferredType() {
        String referredFlowName = "inferredFlow";
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        EventType inferredEventType = new EventType();
        DefinesTypeAnnotation inferredDefinesTypeAnnotation = new DefinesTypeAnnotation(inferredEventType);
        Mockito.when((Object)this.parameterAst.getResolvedRawValue()).thenReturn((Object)referredFlowName);
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode(referredFlowName)).thenReturn(Optional.of(muleFlowNode));
        Mockito.when((Object)muleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.empty()).thenReturn(Optional.of(inferredDefinesTypeAnnotation));
        try {
            EventType eventType = this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testResolveWithThrowsErrorsTypeAnnotation() {
        String referredFlowName = "errorFlow";
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        ThrowsErrorsTypeAnnotation throwsErrorsTypeAnnotation = (ThrowsErrorsTypeAnnotation)Mockito.mock(ThrowsErrorsTypeAnnotation.class);
        Mockito.when((Object)this.parameterAst.getResolvedRawValue()).thenReturn((Object)referredFlowName);
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode(referredFlowName)).thenReturn(Optional.of(muleFlowNode));
        Mockito.when((Object)muleFlowNode.getAnnotation(ThrowsErrorsTypeAnnotation.class)).thenReturn(Optional.of(throwsErrorsTypeAnnotation));
        try {
            this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

