/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ScatterGatherTypeResolver;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class ScatterGatherTypeResolverTest {
    private ScatterGatherTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private EventType inputEventType;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;

    @Before
    public void setUp() {
        this.resolver = new ScatterGatherTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.inputEventType = (EventType)Mockito.mock(EventType.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testResolveWithCollectList() {
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)componentAst);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)componentAst.getParameter("Aggregation", "collectList")).thenReturn((Object)componentParameterAst);
        MessageProcessorNode nestedNode1 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode nestedNode2 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Arrays.asList(nestedNode1, nestedNode2).stream());
        EventType nestedEventType1 = (EventType)Mockito.mock(EventType.class);
        EventType nestedEventType2 = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)nestedNode1, this.inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)nestedEventType1);
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)nestedNode2, this.inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)nestedEventType2);
        MessageMetadataType messageMetadataType1 = (MessageMetadataType)Mockito.mock(MessageMetadataType.class);
        MessageMetadataType messageMetadataType2 = (MessageMetadataType)Mockito.mock(MessageMetadataType.class);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)1));
        MetadataType payloadType1 = (MetadataType)Mockito.mock(MetadataType.class);
        MetadataType payloadType2 = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)messageMetadataType1.getPayloadType()).thenReturn(Optional.of(payloadType1));
        Mockito.when((Object)messageMetadataType2.getPayloadType()).thenReturn(Optional.of(payloadType2));
        EventType result = this.resolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testResolveWithCollectMap() {
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)componentAst);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)componentAst.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)componentParameterAst);
        MessageProcessorNode nestedNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Arrays.asList(nestedNode).stream());
        EventType nestedEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)nestedNode, this.inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)nestedEventType);
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)nestedNode.getComponentModel()).thenReturn((Object)componentAst);
        Mockito.when((Object)componentAst.getLocation()).thenReturn((Object)componentLocation);
        LocationPart locationPart = (LocationPart)Mockito.mock(LocationPart.class);
        Mockito.when((Object)componentLocation.getParts()).thenReturn(Arrays.asList(locationPart));
        Mockito.when((Object)locationPart.getPartPath()).thenReturn((Object)"testRoute");
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.left((Object)"help"));
        MessageMetadataType messageMetadataType = (MessageMetadataType)Mockito.mock(MessageMetadataType.class);
        MetadataType payloadType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)messageMetadataType.getPayloadType()).thenReturn(Optional.of(payloadType));
        EventType result = this.resolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testIsSequential() {
        Assert.assertFalse((boolean)this.resolver.isSequential());
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testIsScope() {
        Assert.assertTrue((boolean)this.resolver.isScope());
    }
}

