/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.batch;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchOnCompleteTypeResolver;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;

public class BatchOnCompleteTypeResolverTest {
    @Mock
    private ComponentIdentifier mockComponentIdentifierScopeIn;
    @Mock
    private ComponentIdentifier mockComponentIdentifierScopeOut;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private EventType mockInputEventType;
    @Mock
    private TypingMuleAstVisitor mockTypingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext mockVisitorContext;
    private BatchOnCompleteTypeResolver batchOnCompleteTypeResolver;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.batchOnCompleteTypeResolver = new BatchOnCompleteTypeResolver(this.mockComponentIdentifierScopeIn, this.mockComponentIdentifierScopeOut);
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.batchOnCompleteTypeResolver.isPropagates(this.mockMessageProcessorNode));
    }

    @Test
    public void testScopeInResolve() {
        BatchOnCompleteTypeResolver.ScopeIn scopeIn = new BatchOnCompleteTypeResolver.ScopeIn();
        MuleEventMetadataTypeBuilder mockBuilder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        MuleEventMetadataType mockEventMetadataType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        Mockito.when((Object)mockBuilder.build()).thenReturn((Object)mockEventMetadataType);
        EventType result = scopeIn.resolve(this.mockMessageProcessorNode, this.mockInputEventType, this.mockTypingMuleAstVisitor, this.mockVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertEquals((Object)this.mockInputEventType, (Object)result);
    }

    @Test
    public void testScopeInResolveWithBatchJobResultMetadataType() {
        BatchOnCompleteTypeResolver.ScopeIn scopeIn = new BatchOnCompleteTypeResolver.ScopeIn();
        MuleEventMetadataTypeBuilder mockBuilder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        MuleEventMetadataType mockEventMetadataType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        Mockito.when((Object)mockBuilder.build()).thenReturn((Object)mockEventMetadataType);
        EventType result = scopeIn.resolve(this.mockMessageProcessorNode, this.mockInputEventType, this.mockTypingMuleAstVisitor, this.mockVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertEquals((Object)this.mockInputEventType, (Object)result);
    }
}

