/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.runtime.api.meta.model.error.ErrorModel;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ErrorHandlingContextTest {
    private ErrorHandlingContext context;
    @Mock
    private EventType eventType;
    @Mock
    private ErrorModel errorModel1;
    @Mock
    private ErrorModel errorModel2;
    @Mock
    private ErrorMatcher errorMatcher;

    @Before
    public void setup() {
        this.context = new ErrorHandlingContext("testContext", this.eventType);
    }

    @Test
    public void testCreationWithEventType() {
        Assert.assertNotNull((Object)this.context);
        Assert.assertTrue((boolean)this.context.isOpen());
        Assert.assertTrue((boolean)this.context.getArgumentEventType().isPresent());
        Assert.assertEquals((Object)this.eventType, this.context.getArgumentEventType().get());
        Assert.assertTrue((boolean)this.context.getUnhandledErrors().isEmpty());
    }

    @Test
    public void testCreationWithoutEventType() {
        this.context = new ErrorHandlingContext("testContext");
        Assert.assertNotNull((Object)this.context);
        Assert.assertTrue((boolean)this.context.isOpen());
        Assert.assertFalse((boolean)this.context.getArgumentEventType().isPresent());
        Assert.assertTrue((boolean)this.context.getUnhandledErrors().isEmpty());
    }

    @Test
    public void testUnionErrors() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        errors.add(this.errorModel1);
        errors.add(this.errorModel2);
        this.context.union(errors);
        Assert.assertEquals((long)2L, (long)this.context.getUnhandledErrors().size());
        Assert.assertTrue((boolean)this.context.getUnhandledErrors().contains(this.errorModel1));
        Assert.assertTrue((boolean)this.context.getUnhandledErrors().contains(this.errorModel2));
    }

    @Test
    public void testHandleErrors() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        errors.add(this.errorModel1);
        errors.add(this.errorModel2);
        this.context.union(errors);
        Mockito.when((Object)this.errorMatcher.matches(this.errorModel1)).thenReturn((Object)true);
        Mockito.when((Object)this.errorMatcher.matches(this.errorModel2)).thenReturn((Object)false);
        this.context.handle(this.errorMatcher);
        Assert.assertEquals((long)1L, (long)this.context.getUnhandledErrors().size());
        Assert.assertFalse((boolean)this.context.getUnhandledErrors().contains(this.errorModel1));
        Assert.assertTrue((boolean)this.context.getUnhandledErrors().contains(this.errorModel2));
    }

    @Test
    public void testClose() {
        Assert.assertTrue((boolean)this.context.isOpen());
        this.context.close();
        Assert.assertFalse((boolean)this.context.isOpen());
    }
}

