/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.munit;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclarationsAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitTestTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;

public class MUnitTestTypeResolverTest {
    @Mock
    private ComponentIdentifier mockComponentIdentifierScopeIn;
    @Mock
    private ComponentIdentifier mockComponentIdentifierScopeOut;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private EventType mockInputEventType;
    @Mock
    private TypingMuleAstVisitor mockTypingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext mockTypingMuleAstVisitorContext;
    @Mock
    private MuleFlowAnnotation mockMuleFlowAnnotation;
    @Mock
    private MuleApplicationAnnotation mockMuleApplicationAnnotation;
    @Mock
    private MUnitDeclarationsAnnotation mockMUnitDeclarationsAnnotation;
    @Mock
    private MuleFlowNode mockMuleFlowNode;
    @Mock
    private MuleApplicationNode mockMuleApplicationNode;
    private MUnitTestTypeResolver mUnitTestTypeResolver;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.mUnitTestTypeResolver = new MUnitTestTypeResolver(this.mockComponentIdentifierScopeIn, this.mockComponentIdentifierScopeOut);
    }

    @Test
    public void testResolve() {
        Mockito.when((Object)this.mockTypingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(this.mockMuleFlowAnnotation));
        Mockito.when((Object)this.mockMuleFlowAnnotation.getMuleFlowNode()).thenReturn((Object)this.mockMuleFlowNode);
        Mockito.when((Object)this.mockTypingMuleAstVisitorContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(this.mockMuleApplicationAnnotation));
        Mockito.when((Object)this.mockMuleApplicationAnnotation.getMuleApplicationNode()).thenReturn((Object)this.mockMuleApplicationNode);
        Mockito.when((Object)this.mockMuleApplicationNode.getAnnotation(MUnitDeclarationsAnnotation.class)).thenReturn(Optional.of(this.mockMUnitDeclarationsAnnotation));
        Mockito.when((Object)this.mockMUnitDeclarationsAnnotation.getBeforeTestMuleFlowNode(this.mockMuleFlowNode)).thenReturn(Optional.of(this.mockMuleFlowNode));
        EventType result = this.mUnitTestTypeResolver.resolve(this.mockMessageProcessorNode, this.mockInputEventType, this.mockTypingMuleAstVisitor, this.mockTypingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
        ((TypingMuleAstVisitorContext)Mockito.verify((Object)this.mockTypingMuleAstVisitorContext)).getAnnotation(MuleFlowAnnotation.class);
        ((TypingMuleAstVisitorContext)Mockito.verify((Object)this.mockTypingMuleAstVisitorContext)).getAnnotation(MuleApplicationAnnotation.class);
        ((MuleApplicationNode)Mockito.verify((Object)this.mockMuleApplicationNode)).getAnnotation(MUnitDeclarationsAnnotation.class);
        ((MUnitDeclarationsAnnotation)Mockito.verify((Object)this.mockMUnitDeclarationsAnnotation)).getBeforeTestMuleFlowNode(this.mockMuleFlowNode);
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.mUnitTestTypeResolver.isPropagates(this.mockMessageProcessorNode));
    }

    @Test
    public void testScopeInResolve() {
        MUnitTestTypeResolver.ScopeIn scopeIn = new MUnitTestTypeResolver.ScopeIn();
        Mockito.when((Object)this.mockTypingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(this.mockMuleFlowAnnotation));
        Mockito.when((Object)this.mockMuleFlowAnnotation.getMuleFlowNode()).thenReturn((Object)this.mockMuleFlowNode);
        Mockito.when((Object)this.mockTypingMuleAstVisitorContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(this.mockMuleApplicationAnnotation));
        Mockito.when((Object)this.mockMuleApplicationAnnotation.getMuleApplicationNode()).thenReturn((Object)this.mockMuleApplicationNode);
        Mockito.when((Object)this.mockMuleApplicationNode.getAnnotation(MUnitDeclarationsAnnotation.class)).thenReturn(Optional.of(this.mockMUnitDeclarationsAnnotation));
        Mockito.when((Object)this.mockMUnitDeclarationsAnnotation.getBeforeTestMuleFlowNode(this.mockMuleFlowNode)).thenReturn(Optional.of(this.mockMuleFlowNode));
        Mockito.when((Object)this.mockMuleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.empty());
        EventType result = scopeIn.resolve(this.mockMessageProcessorNode, this.mockInputEventType, this.mockTypingMuleAstVisitor, this.mockTypingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testScopeInIsPropagates() {
        MUnitTestTypeResolver.ScopeIn scopeIn = new MUnitTestTypeResolver.ScopeIn();
        Assert.assertTrue((boolean)scopeIn.isPropagates(this.mockMessageProcessorNode));
    }
}

