/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.tooling;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.tooling.NodeInfoQuery;
import org.mule.runtime.api.component.location.Location;

public class NodeInfoQueryTest {
    @Mock
    private MuleApplicationNode mockMuleApplicationNode;
    @Mock
    private DataSenseProviderResolver mockDataSenseProviderResolver;
    @Mock
    private AstNotification mockAstNotification;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private ComponentLocationAnnotation mockComponentLocationAnnotation;
    private Location testLocation;
    private NodeInfoQuery nodeInfoQuery;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testLocation = Location.builder().globalName("GlobalName1").build();
        this.nodeInfoQuery = new NodeInfoQuery(this.testLocation);
    }

    @Test
    public void testPerformWithMatchingNode() {
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(this.testLocation)).thenReturn(Optional.of(this.mockMessageProcessorNode));
        Mockito.when((Object)this.mockMessageProcessorNode.getAnnotation(ComponentLocationAnnotation.class)).thenReturn(Optional.of(this.mockComponentLocationAnnotation));
        Optional result = this.nodeInfoQuery.perform(this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull(result.get());
    }

    @Test
    public void testPerformWithNoMatchingNode() {
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(this.testLocation)).thenReturn(Optional.empty());
        Optional result = this.nodeInfoQuery.perform(this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testPerformWithMatchingNodeButNoAnnotation() {
        Mockito.when((Object)this.mockMuleApplicationNode.findMessageProcessorNode(this.testLocation)).thenReturn(Optional.of(this.mockMessageProcessorNode));
        Mockito.when((Object)this.mockMessageProcessorNode.getAnnotation(ComponentLocationAnnotation.class)).thenReturn(Optional.empty());
        Optional result = this.nodeInfoQuery.perform(this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertFalse((boolean)result.isPresent());
    }
}

