package org.mule.datasense.impl.model.annotations;

import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.util.extension.OperationModelTransform;
import org.mule.datasense.impl.util.extension.OutputModelTransform;
import org.mule.datasense.impl.util.extension.ParameterGroupModelTransform;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MetadataKey;

import java.util.Map;
import java.util.Set;

public class OperationModelMetadataKeyEnricher extends ComponentModelMetadataKeyEnricher<OperationModel> {

  protected OperationModel enrich(OperationModel operationModel, Map<String, Set<MetadataKey>> metadataKeysByPart,
                                  OperationCall operationCall) {
    if (metadataKeysByPart == null && operationCall == null) {
      return operationModel;
    }

    final OperationModelTransform operationModelTransform =
        new OperationModelTransform(
                                    new ParameterGroupModelTransform(getParameterModelMetadataTypeFunction(metadataKeysByPart,
                                                                                                           operationCall)),
                                    new OutputModelTransform(getOutputMetadataTypeFunction(operationCall)),
                                    new OutputModelTransform(getOutputAttributesMetadataTypeFunction(operationCall)));

    return operationModelTransform.transform(operationModel);
  }
}
