package org.mule.datasense.impl.util;

import org.apache.commons.lang3.StringUtils;
import org.mule.datasense.impl.util.LogSupport;

public class TreeLogSupport implements LogSupport {

  private int level;

  public void debug(String text, Object... objects) {
    logger().debug(StringUtils.repeat("\t", level) + text, objects);
  }

  public void enter(String name) {
    level++;
    debug(">> entering " + name + "...");
  }

  public void exit(String name) {
    debug("<< leaving " + name + ".");
    level--;
  }
}
