/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.OnErrorTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingEnvironment;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class OnErrorTypeResolverTest {
    private OnErrorTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private EventType inputEventType;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;
    private ErrorHandlingEnvironment errorHandlingEnvironment;
    private ErrorHandlingContext errorHandlingContext;

    @Before
    public void setUp() {
        this.resolver = new OnErrorTypeResolver(true);
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.inputEventType = (EventType)Mockito.mock(EventType.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        this.errorHandlingEnvironment = (ErrorHandlingEnvironment)Mockito.mock(ErrorHandlingEnvironment.class);
        this.errorHandlingContext = (ErrorHandlingContext)Mockito.mock(ErrorHandlingContext.class);
        Mockito.when((Object)this.typingMuleAstVisitorContext.getErrorHandlingEnvironment()).thenReturn((Object)this.errorHandlingEnvironment);
        Mockito.when((Object)this.errorHandlingEnvironment.getContext()).thenReturn((Object)this.errorHandlingContext);
    }

    @Test
    public void testGenerateAst() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = OnErrorTypeResolver.class.getDeclaredMethod("generateAst", ComponentIdentifier.class, ComponentAst.class, ComponentModelType.class, List.class);
        method.setAccessible(true);
        method.invoke((Object)this.resolver, Mockito.mock(ComponentIdentifier.class), Mockito.mock(ComponentAst.class), ComponentModelType.MESSAGE_PROCESSOR_NODE, Arrays.asList((MessageProcessorNodeBuilder)Mockito.mock(MessageProcessorNodeBuilder.class)));
    }

    @Test
    public void testDefinesErrorHandlingContext() {
        Assert.assertFalse((boolean)this.resolver.definesErrorHandlingContext());
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testGetParseProvider() {
        Assert.assertTrue((boolean)this.resolver.getParseProvider().isPresent());
    }

    @Test
    public void testScopeInResolve() {
        OnErrorTypeResolver.ScopeIn scopeIn = new OnErrorTypeResolver.ScopeIn();
        EventType result = scopeIn.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.times((int)2))).annotate((AstNodeAnnotation)Mockito.any());
    }

    @Test
    public void testScopeInIsPropagates() {
        OnErrorTypeResolver.ScopeIn scopeIn = new OnErrorTypeResolver.ScopeIn();
        Assert.assertFalse((boolean)scopeIn.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testScopeInIsScope() {
        OnErrorTypeResolver.ScopeIn scopeIn = new OnErrorTypeResolver.ScopeIn();
        Assert.assertTrue((boolean)scopeIn.isScope());
    }

    @Test
    public void testScopeInDefinesErrorHandlingContext() {
        OnErrorTypeResolver.ScopeIn scopeIn = new OnErrorTypeResolver.ScopeIn();
        Assert.assertFalse((boolean)scopeIn.definesErrorHandlingContext());
    }
}

