/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedInputAnnotation;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.MessageProcessorTypeDeclarationAnnotation;
import org.mule.datasense.impl.model.annotations.ResultEventAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitor;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;
import org.mule.datasense.impl.phases.typing.MessageProcessorScope;
import org.mule.datasense.impl.phases.typing.TypingEnvironment;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.BaseTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingEnvironment;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseTypeResolverTest {
    private TestBaseTypeResolver baseTypeResolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;
    @Mock
    private IncomingAstVisitor incomingAstVisitor;
    @Mock
    private IncomingAstVisitorContext incomingAstVisitorContext;
    @Mock
    private ExpectedAstVisitor expectedAstVisitor;
    @Mock
    private ExpectedAstVisitorContext expectedAstVisitorContext;

    @Before
    public void setUp() {
        this.baseTypeResolver = new TestBaseTypeResolver();
        Mockito.when((Object)this.expectedAstVisitorContext.logger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.incomingAstVisitorContext.logger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
    }

    @Test
    public void testGetComponentModelType() {
        Assert.assertEquals(Optional.empty(), (Object)this.baseTypeResolver.getComponentModelType());
    }

    @Test
    public void testResolveTypes() {
        EventType inputEventType = new EventType();
        EventType resultEventType = new EventType();
        MessageProcessorTypeDeclarationAnnotation messageProcessorTypeDeclarationAnnotation = (MessageProcessorTypeDeclarationAnnotation)Mockito.mock(MessageProcessorTypeDeclarationAnnotation.class);
        FunctionType functionType = (FunctionType)Mockito.mock(FunctionType.class);
        MuleEventMetadataType metadataType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        Mockito.when((Object)this.typingMuleAstVisitorContext.getTypingEnvironment()).thenReturn((Object)((TypingEnvironment)Mockito.mock(TypingEnvironment.class)));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getTypingEnvironment().get()).thenReturn((Object)((MessageProcessorScope)Mockito.mock(MessageProcessorScope.class)));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getTypingEnvironment().get().resolveInput()).thenReturn((Object)inputEventType);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(MessageProcessorTypeDeclarationAnnotation.class)).thenReturn(Optional.of(messageProcessorTypeDeclarationAnnotation));
        Mockito.when((Object)this.typingMuleAstVisitorContext.getErrorHandlingEnvironment()).thenReturn((Object)((ErrorHandlingEnvironment)Mockito.mock(ErrorHandlingEnvironment.class)));
        Mockito.when((Object)metadataType.getMessageType()).thenReturn((Object)((MessageMetadataType)Mockito.mock(MessageMetadataType.class)));
        Mockito.when((Object)metadataType.getVariables()).thenReturn((Object)((ObjectType)Mockito.mock(ObjectType.class)));
        Mockito.when((Object)((UsesTypeAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(UsesTypeAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)((UsesTypeAnnotation)Mockito.mock(UsesTypeAnnotation.class)));
        Mockito.when((Object)((DefinesTypeAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(DefinesTypeAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)((DefinesTypeAnnotation)Mockito.mock(DefinesTypeAnnotation.class)));
        Mockito.when((Object)functionType.getReturnType()).thenReturn(Optional.of(metadataType));
        Mockito.when((Object)messageProcessorTypeDeclarationAnnotation.getMessageProcessorTypeDeclaration()).thenReturn((Object)((MessageProcessorTypeDeclaration)Mockito.mock(MessageProcessorTypeDeclaration.class)));
        Mockito.when((Object)messageProcessorTypeDeclarationAnnotation.getMessageProcessorTypeDeclaration().getFunctionType()).thenReturn((Object)functionType);
        Mockito.when((Object)functionType.getParameters()).thenReturn(Arrays.asList((FunctionParameter)Mockito.mock(FunctionParameter.class)));
        Mockito.when((Object)((FunctionParameter)functionType.getParameters().get(0)).getType()).thenReturn((Object)metadataType);
        this.baseTypeResolver.setResolveResult(resultEventType);
        this.baseTypeResolver.setPropagates(true);
        EventType outputEventType = this.baseTypeResolver.resolveTypes(this.messageProcessorNode, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)outputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).getAnnotation(ThrowsErrorsTypeAnnotation.class);
    }

    @Test
    public void testGenerateIncoming() {
        EventType incomingEventType = new EventType();
        Mockito.when((Object)this.incomingAstVisitorContext.getIncomingEventType()).thenReturn((Object)incomingEventType);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.empty());
        EventType outputEventType = this.baseTypeResolver.generateIncoming(this.messageProcessorNode, this.incomingAstVisitor, this.incomingAstVisitorContext);
        Assert.assertNotNull((Object)outputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((IncomingEventAnnotation)Mockito.any(IncomingEventAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ResultEventAnnotation)Mockito.any(ResultEventAnnotation.class)));
    }

    @Test
    public void testGenerateExpected() {
        EventType expectedEventType = new EventType();
        Mockito.when((Object)this.expectedAstVisitorContext.getExpectedEventType()).thenReturn((Object)expectedEventType);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.of(this.messageProcessorNode));
        EventType inputEventType = this.baseTypeResolver.generateExpected(this.messageProcessorNode, this.expectedAstVisitor, this.expectedAstVisitorContext);
        Assert.assertNotNull((Object)inputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ExpectedEventAnnotation)Mockito.any(ExpectedEventAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ExpectedInputAnnotation)Mockito.any(ExpectedInputAnnotation.class)));
    }

    @Test
    public void testGenerateExpected_NotSeq() {
        EventType expectedEventType = new EventType();
        class BaseTypeResolverMockTest
        extends BaseTypeResolver {
            BaseTypeResolverMockTest() {
            }

            protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
                return null;
            }

            protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
                return false;
            }

            protected boolean isSequential() {
                return false;
            }
        }
        BaseTypeResolverMockTest mockBaseTypeResolver = new BaseTypeResolverMockTest();
        Mockito.when((Object)this.expectedAstVisitorContext.getExpectedEventType()).thenReturn((Object)expectedEventType);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.of(this.messageProcessorNode));
        try {
            mockBaseTypeResolver.generateExpected(this.messageProcessorNode, this.expectedAstVisitor, this.expectedAstVisitorContext);
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)this.expectedAstVisitorContext);
        }
    }

    @Test
    public void testProcessTarget() {
        EventType eventType = new EventType();
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        AstNotification astNotification = (AstNotification)Mockito.mock(AstNotification.class);
        AstNodeLocation astNodeLocation = (AstNodeLocation)Mockito.mock(AstNodeLocation.class);
        Mockito.when((Object)this.typingMuleAstVisitorContext.getAstNotification()).thenReturn((Object)astNotification);
        Mockito.when((Object)this.messageProcessorNode.getAstNodeLocation()).thenReturn((Object)astNodeLocation);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)componentAst);
        EventType inputEventType = this.baseTypeResolver.processTarget(eventType, this.messageProcessorNode, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)inputEventType);
    }

    private class TestBaseTypeResolver
    extends BaseTypeResolver {
        private EventType resolveResult;
        private boolean propagates;

        private TestBaseTypeResolver() {
        }

        public void setResolveResult(EventType resolveResult) {
            this.resolveResult = resolveResult;
        }

        public void setPropagates(boolean propagates) {
            this.propagates = propagates;
        }

        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            return this.resolveResult;
        }

        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return this.propagates;
        }

        public EventType processTarget(EventType eventType, MessageProcessorNode messageProcessorNode, TypingMuleAstVisitorContext visitorContext) {
            return super.processTarget(eventType, messageProcessorNode, visitorContext);
        }
    }
}

