/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.ast;

import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleFlowNodeTest {
    private ComponentIdentifier mockComponentIdentifier;
    private ComponentAst mockComponentModel;
    private MessageProcessorNode mockRootMessageProcessorNode;
    private MuleFlowNode muleFlowNode;

    @Before
    public void setUp() {
        this.mockComponentIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.mockComponentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.mockRootMessageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)this.mockComponentModel.getComponentId()).thenReturn(Optional.of("testFlow"));
        this.muleFlowNode = new MuleFlowNode(this.mockComponentIdentifier, this.mockComponentModel, this.mockRootMessageProcessorNode);
    }

    @Test
    public void testConstructorWithRootMessageProcessor() {
        Assert.assertNotNull((Object)this.muleFlowNode);
        Assert.assertEquals((Object)"testFlow", (Object)this.muleFlowNode.getName());
        Assert.assertTrue((boolean)this.muleFlowNode.getRootMessageProcessorNode().isPresent());
    }

    @Test
    public void testConstructorWithoutRootMessageProcessor() {
        MuleFlowNode nodeWithoutRoot = new MuleFlowNode(this.mockComponentIdentifier, this.mockComponentModel);
        Assert.assertNotNull((Object)nodeWithoutRoot);
        Assert.assertEquals((Object)"testFlow", (Object)nodeWithoutRoot.getName());
        Assert.assertFalse((boolean)nodeWithoutRoot.getRootMessageProcessorNode().isPresent());
    }

    @Test
    public void testGetAndSetParentAstNode() {
        AstNode mockParentNode = (AstNode)Mockito.mock(AstNode.class);
        this.muleFlowNode.setParentAstNode(mockParentNode);
        Assert.assertEquals((Object)mockParentNode, (Object)this.muleFlowNode.getParentAstNode());
    }

    @Test
    public void testGetComponentModel() {
        Assert.assertEquals((Object)this.mockComponentModel, (Object)this.muleFlowNode.getComponentModel());
    }

    @Test
    public void testAccept() {
        AstNodeVisitor mockVisitor = (AstNodeVisitor)Mockito.mock(AstNodeVisitor.class);
        Object mockContext = new Object();
        this.muleFlowNode.accept(mockVisitor, mockContext);
        ((AstNodeVisitor)Mockito.verify((Object)mockVisitor)).visit(this.muleFlowNode, mockContext);
    }

    @Test
    public void testRegisterAndFindMessageProcessorNode() {
        ComponentLocation mockLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockLocation.getLocation()).thenReturn((Object)"testLocation");
        this.muleFlowNode.register(mockLocation, mockNode);
        Optional foundNode = this.muleFlowNode.findMessageProcessorNode("testLocation");
        Assert.assertTrue((boolean)foundNode.isPresent());
        Assert.assertEquals((Object)mockNode, foundNode.get());
    }

    @Test(expected=IllegalStateException.class)
    public void testRegisterDuplicateLocation() {
        ComponentLocation mockLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockLocation.getLocation()).thenReturn((Object)"testLocation");
        this.muleFlowNode.register(mockLocation, mockNode);
        this.muleFlowNode.register(mockLocation, mockNode);
    }

    @Test
    public void testFindMessageProcessorNodes() {
        ComponentLocation mockLocation1 = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        ComponentLocation mockLocation2 = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        MessageProcessorNode mockNode1 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode mockNode2 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockLocation1.getLocation()).thenReturn((Object)"location1");
        Mockito.when((Object)mockLocation2.getLocation()).thenReturn((Object)"location2");
        Mockito.when((Object)mockNode1.isRootMessageProcessorNode()).thenReturn((Object)true);
        Mockito.when((Object)mockNode2.isRootMessageProcessorNode()).thenReturn((Object)false);
        this.muleFlowNode.register(mockLocation1, mockNode1);
        this.muleFlowNode.register(mockLocation2, mockNode2);
        Stream nodesExcludingRoot = this.muleFlowNode.findMessageProcessorNodes();
        Assert.assertEquals((long)1L, (long)nodesExcludingRoot.count());
        Stream nodesIncludingRoot = this.muleFlowNode.findMessageProcessorNodes(true);
        Assert.assertEquals((long)2L, (long)nodesIncludingRoot.count());
    }

    @Test
    public void testFindNonExistentMessageProcessorNode() {
        Optional nonExistentNode = this.muleFlowNode.findMessageProcessorNode("nonExistent");
        Assert.assertFalse((boolean)nonExistentNode.isPresent());
    }
}

