/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.matchers;

import java.util.Objects;
import java.util.function.Predicate;
import org.hamcrest.Description;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.matchers.PredicateTypeSafeMatcher;
import org.mule.metadata.api.model.MetadataType;

public class MetadataTypeMatcher
extends PredicateTypeSafeMatcher<MetadataType> {
    public MetadataTypeMatcher(Predicate<MetadataType> predicate) {
        super(predicate, MetadataType.class);
    }

    public void describeTo(Description description) {
        description.appendText("metadata type");
    }

    @Override
    protected void describeMismatchSafely(MetadataType item, Description mismatchDescription) {
        mismatchDescription.appendText(TypesHelper.toString((MetadataType)item));
    }

    public static class IsAs
    extends MetadataTypeMatcher {
        private final String expectedType;

        public IsAs(String expectedType) {
            super((MetadataType actualType) -> IsAs.compare(TypesHelper.toString((MetadataType)actualType), expectedType));
            this.expectedType = expectedType;
        }

        private static boolean compare(String string1, String string2) {
            return Objects.equals(IsAs.stripSpace(string1), IsAs.stripSpace(string2));
        }

        private static String stripSpace(String toBeStripped) {
            StringBuilder result = new StringBuilder();
            boolean lastWasSpace = true;
            for (int i = 0; i < toBeStripped.length(); ++i) {
                char c = toBeStripped.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!lastWasSpace) {
                        result.append(' ');
                    }
                    lastWasSpace = true;
                    continue;
                }
                result.append(c);
                lastWasSpace = false;
            }
            return result.toString().trim();
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(this.expectedType);
        }

        @Override
        protected void describeMismatchSafely(MetadataType actualType, Description mismatchDescription) {
            mismatchDescription.appendText(TypesHelper.toString((MetadataType)actualType));
        }
    }
}

