/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Arrays;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.types.TypeEquivalence;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.RegexType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.UnionType;

public class TypeEquivalenceTest {
    @Test
    public void testCanBeAssignedTo_UnionType() {
        UnionType assignmentType = (UnionType)Mockito.mock(UnionType.class);
        MetadataType expectedType = (MetadataType)Mockito.mock(MetadataType.class);
        MetadataType subType1 = (MetadataType)Mockito.mock(MetadataType.class);
        MetadataType subType2 = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)assignmentType.getTypes()).thenReturn(Arrays.asList(subType1, subType2));
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_NothingType() {
        NothingType assignmentType = (NothingType)Mockito.mock(NothingType.class);
        MetadataType expectedType = (MetadataType)Mockito.mock(MetadataType.class);
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_ObjectType() {
        ObjectType assignmentType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType expectedType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectFieldType field1 = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectFieldType field2 = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        Mockito.when((Object)expectedType.getFields()).thenReturn(Arrays.asList(field1, field2));
        Mockito.when((Object)assignmentType.getFields()).thenReturn(Arrays.asList(field1, field2));
        Mockito.when((Object)field1.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)field2.isRequired()).thenReturn((Object)false);
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_ObjectKeyType() {
        ObjectKeyType assignmentType = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        ObjectKeyType expectedType = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)assignmentType.getName()).thenReturn((Object)new QName("test1"));
        Mockito.when((Object)expectedType.getName()).thenReturn((Object)new QName("test1"));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_AllType() {
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(NullType.class)), (MetadataType)((MetadataType)Mockito.mock(NullType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(RegexType.class)), (MetadataType)((MetadataType)Mockito.mock(RegexType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(BinaryType.class)), (MetadataType)((MetadataType)Mockito.mock(BinaryType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(PeriodType.class)), (MetadataType)((MetadataType)Mockito.mock(PeriodType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(TimeZoneType.class)), (MetadataType)((MetadataType)Mockito.mock(TimeZoneType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(TimeType.class)), (MetadataType)((MetadataType)Mockito.mock(TimeType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(LocalTimeType.class)), (MetadataType)((MetadataType)Mockito.mock(LocalTimeType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(LocalDateTimeType.class)), (MetadataType)((MetadataType)Mockito.mock(LocalDateTimeType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(DateTimeType.class)), (MetadataType)((MetadataType)Mockito.mock(DateTimeType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(NumberType.class)), (MetadataType)((MetadataType)Mockito.mock(NumberType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(BooleanType.class)), (MetadataType)((MetadataType)Mockito.mock(BooleanType.class)), Optional.empty()));
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(FunctionType.class)), (MetadataType)((MetadataType)Mockito.mock(FunctionType.class)), Optional.empty()));
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(TypeParameterType.class)), (MetadataType)((MetadataType)Mockito.mock(TypeParameterType.class)), Optional.empty()));
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)((MetadataType)Mockito.mock(UnionType.class)), (MetadataType)((MetadataType)Mockito.mock(UnionType.class)), Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_ArrayType() {
        ArrayType assignmentType = (ArrayType)Mockito.mock(ArrayType.class);
        ArrayType expectedType = (ArrayType)Mockito.mock(ArrayType.class);
        MetadataType itemType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)assignmentType.getType()).thenReturn((Object)itemType);
        Mockito.when((Object)expectedType.getType()).thenReturn((Object)itemType);
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_UnionTypeExpected() {
        MetadataType assignmentType = (MetadataType)Mockito.mock(MetadataType.class);
        UnionType expectedType = (UnionType)Mockito.mock(UnionType.class);
        MetadataType subType1 = (MetadataType)Mockito.mock(MetadataType.class);
        MetadataType subType2 = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)expectedType.getTypes()).thenReturn(Arrays.asList(subType1, subType2));
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_AnyType() {
        MetadataType assignmentType = (MetadataType)Mockito.mock(MetadataType.class);
        AnyType expectedType = (AnyType)Mockito.mock(AnyType.class);
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_StringType() {
        StringType assignmentType = (StringType)Mockito.mock(StringType.class);
        StringType expectedType = (StringType)Mockito.mock(StringType.class);
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_NumberType() {
        NumberType assignmentType = (NumberType)Mockito.mock(NumberType.class);
        NumberType expectedType = (NumberType)Mockito.mock(NumberType.class);
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_BooleanType() {
        BooleanType assignmentType = (BooleanType)Mockito.mock(BooleanType.class);
        BooleanType expectedType = (BooleanType)Mockito.mock(BooleanType.class);
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_DateTimeType() {
        DateTimeType assignmentType = (DateTimeType)Mockito.mock(DateTimeType.class);
        DateTimeType expectedType = (DateTimeType)Mockito.mock(DateTimeType.class);
        Assert.assertTrue((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }

    @Test
    public void testCanBeAssignedTo_UnsupportedType() {
        MetadataType assignmentType = (MetadataType)Mockito.mock(MetadataType.class);
        MetadataType expectedType = (MetadataType)Mockito.mock(MetadataType.class);
        Assert.assertFalse((boolean)TypeEquivalence.canBeAssignedTo((MetadataType)assignmentType, (MetadataType)expectedType, Optional.empty()));
    }
}

