/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleEventExprAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TransformTypeResolver;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class TransformTypeResolverTest {
    private TransformTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private EventType inputEventType;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext visitorContext;

    @Before
    public void setUp() {
        this.resolver = new TransformTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.inputEventType = (EventType)Mockito.mock(EventType.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.visitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testResolveWithoutMuleEventExprAnnotation() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(MuleEventExprAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.visitorContext.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        Mockito.when((Object)this.messageProcessorNode.getAstNodeLocation()).thenReturn((Object)((AstNodeLocation)Mockito.mock(AstNodeLocation.class)));
        Mockito.when((Object)this.visitorContext.getExpressionLanguageMetadataService()).thenReturn((Object)((ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)));
        EventType result = this.resolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

