/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.TypeResolverAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class TypeResolverAnnotatorTest {
    private TypeResolverRegistry typeResolverRegistry;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext visitorContext;
    private ComponentAst componentAst;
    private ComponentIdentifier componentIdentifier;
    private TypeResolver typeResolver;

    @Before
    public void setUp() {
        this.typeResolverRegistry = (TypeResolverRegistry)Mockito.mock(TypeResolverRegistry.class);
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.visitorContext = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.componentIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentAst);
        Mockito.when((Object)this.messageProcessorNode.getComponentIdentifier()).thenReturn((Object)this.componentIdentifier);
    }

    @Test
    public void testAnnotateWithTypeResolver() {
        Mockito.when((Object)this.typeResolverRegistry.get(this.componentIdentifier)).thenReturn(Optional.of(this.typeResolver));
        TypeResolverAnnotator annotator = new TypeResolverAnnotator(this.typeResolverRegistry);
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }

    @Test
    public void testAnnotateWithoutTypeResolver() {
        Mockito.when((Object)this.typeResolverRegistry.get(this.componentIdentifier)).thenReturn(Optional.empty());
        TypeResolverAnnotator annotator = new TypeResolverAnnotator(this.typeResolverRegistry);
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }
}

