/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.BaseTypeResolverTestOld;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.BaseTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=Parameterized.class)
public class PropagationTypeResolverTest
extends BaseTypeResolverTestOld {
    public PropagationTypeResolverTest(String name, Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier, TypeResolver typeResolver, String usesMetadataTypeData, String definesMetadataTypeData, String resultMetadataTypeData) {
        super(name, "propagation", inputMuleEventMetadataTypeBuilderSupplier, () -> (ComponentAst)Mockito.mock(ComponentAst.class), ArrayList::new, () -> (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class), typeResolver, usesMetadataTypeData, definesMetadataTypeData, resultMetadataTypeData);
    }

    private static List<Object[]> passthroughCases() {
        BaseTypeResolver passthroughTypeResolver = new BaseTypeResolver(){

            protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
                messageProcessorNode.annotate((AstNodeAnnotation)new UsesTypeAnnotation(new EventType()));
                messageProcessorNode.annotate((AstNodeAnnotation)new DefinesTypeAnnotation(new EventType()));
                return inputEventType;
            }

            protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
                return true;
            }
        };
        String passthroughUsesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        String passthroughDefinesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        return Arrays.asList({"propagation-with-empty-input", MuleEventMetadataTypeBuilder::new, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-payload-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-attributes-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-variables-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.addVariable("v1").stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"});
    }

    private static List<Object[]> defineAttributeResolver() {
        BaseTypeResolver passthroughTypeResolver = new BaseTypeResolver(){

            protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
                messageProcessorNode.annotate((AstNodeAnnotation)new UsesTypeAnnotation(new EventType()));
                messageProcessorNode.annotate((AstNodeAnnotation)new DefinesTypeAnnotation(new EventType()));
                return inputEventType;
            }

            protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
                return true;
            }
        };
        String passthroughUsesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        String passthroughDefinesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        return Arrays.asList({"propagation-with-empty-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-payload-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-attributes-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-variables-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.addVariable("v1").stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"});
    }

    private static List<Object[]> definePayloadResolver() {
        BaseTypeResolver passthroughTypeResolver = new BaseTypeResolver(){

            protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
                messageProcessorNode.annotate((AstNodeAnnotation)new UsesTypeAnnotation(new EventType()));
                messageProcessorNode.annotate((AstNodeAnnotation)new DefinesTypeAnnotation(new EventType()));
                return inputEventType;
            }

            protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
                return true;
            }
        };
        String passthroughUsesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        String passthroughDefinesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        return Arrays.asList({"propagation-with-empty-input", MuleEventMetadataTypeBuilder::new, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-payload-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-attributes-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-variables-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.addVariable("v1").stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"});
    }

    private static List<Object[]> defineVariablesResolver() {
        BaseTypeResolver passthroughTypeResolver = new BaseTypeResolver(){

            protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
                messageProcessorNode.annotate((AstNodeAnnotation)new UsesTypeAnnotation(new EventType()));
                messageProcessorNode.annotate((AstNodeAnnotation)new DefinesTypeAnnotation(new EventType()));
                return inputEventType;
            }

            protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
                return true;
            }
        };
        String passthroughUsesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        String passthroughDefinesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        return Arrays.asList({"propagation-with-empty-input", MuleEventMetadataTypeBuilder::new, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-payload-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-attributes-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"propagation-with-variables-input", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.addVariable("v1").stringType();
            return muleEventMetadataTypeBuilder;
        }, passthroughTypeResolver, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"});
    }

    @Parameterized.Parameters(name="{0}-{index}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(PropagationTypeResolverTest.passthroughCases());
        parameters.addAll(PropagationTypeResolverTest.definePayloadResolver());
        parameters.addAll(PropagationTypeResolverTest.defineAttributeResolver());
        parameters.addAll(PropagationTypeResolverTest.defineVariablesResolver());
        return parameters;
    }
}

