/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.ast2.test.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.dw.DwTypeWriter;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

@RunWith(value=Parameterized.class)
public class AsMuleEventMetadataTypeTest {
    private final Consumer<TypeBuilder> typeBuilderConsumer;

    public AsMuleEventMetadataTypeTest(String name, Consumer<TypeBuilder> typeBuilderConsumer) {
        this.typeBuilderConsumer = typeBuilderConsumer;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"empty", muleEventMetadataTypeBuilder -> {}}, {"payload", muleEventMetadataTypeBuilder -> muleEventMetadataTypeBuilder.message().payload().stringType()}, {"attributes", muleEventMetadataTypeBuilder -> muleEventMetadataTypeBuilder.message().attributes().stringType()}, {"payloadWithAttributes", muleEventMetadataTypeBuilder -> {
            muleEventMetadataTypeBuilder.message().payload().stringType();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
        }}, {"variables", muleEventMetadataTypeBuilder -> {
            muleEventMetadataTypeBuilder.addVariable("var1").stringType();
            muleEventMetadataTypeBuilder.addVariable("var2").numberType();
        }}, {"muleevent", muleEventMetadataTypeBuilder -> {
            muleEventMetadataTypeBuilder.message().payload().stringType();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            muleEventMetadataTypeBuilder.addVariable("var1").stringType();
            muleEventMetadataTypeBuilder.addVariable("var2").numberType();
        }});
    }

    @Test
    public void test() {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
        this.typeBuilderConsumer.accept((TypeBuilder)muleEventMetadataTypeBuilder);
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        MuleEventMetadataType newMuleEventMetadataType = (MuleEventMetadataType)TypeUtils.asMuleEventMetadataType((MetadataType)muleEventMetadataType).orElseThrow(AssertionError::new);
        Assert.assertThat((Object)newMuleEventMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(TypesHelper.toString((MetadataType)muleEventMetadataType)));
    }

    @Test
    public void testUsingWeaveSerialization() {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
        this.typeBuilderConsumer.accept((TypeBuilder)muleEventMetadataTypeBuilder);
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        MuleEventMetadataType newMuleEventMetadataType = this.createMetadataType(muleEventMetadataType);
        Assert.assertThat((Object)newMuleEventMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(TypesHelper.toString((MetadataType)muleEventMetadataType)));
    }

    private MuleEventMetadataType createMetadataType(MuleEventMetadataType muleEventMetadataType) {
        DwTypeWriter dwTypeWriter = new DwTypeWriter(ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
        String name = "aType";
        String serialized = dwTypeWriter.write((MetadataType)muleEventMetadataType, "aType");
        TypeLoader typeLoader = ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService().createTypeLoader(serialized, MetadataFormat.JAVA);
        MetadataType newMetadataType = (MetadataType)typeLoader.load("aType").orElseThrow(IllegalArgumentException::new);
        Assert.assertFalse((boolean)(newMetadataType instanceof MessageMetadataType));
        return (MuleEventMetadataType)TypeUtils.asMuleEventMetadataType((MetadataType)newMetadataType).orElseThrow(AssertionError::new);
    }
}

