/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.annotations.munit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclaration;
import org.mule.datasense.impl.model.ast.MuleFlowNode;

@RunWith(value=MockitoJUnitRunner.class)
public class MUnitDeclarationTest {
    private MUnitDeclaration declaration;
    private MuleFlowNode mockFlowNode;

    @Before
    public void setUp() {
        this.declaration = new MUnitDeclaration();
        this.mockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
    }

    @Test
    public void testInitialState() {
        Assert.assertNull((Object)this.declaration.getBeforeTestMuleFlowNode());
        Assert.assertNull((Object)this.declaration.getAfterTestMuleFlowNode());
        Assert.assertNull((Object)this.declaration.getBeforeSuiteMuleFlowNode());
        Assert.assertNull((Object)this.declaration.getAfterSuiteMuleFlowNode());
    }

    @Test
    public void testSetAndGetBeforeTestMuleFlowNode() {
        this.declaration.setBeforeTestMuleFlowNode(this.mockFlowNode);
        Assert.assertEquals((Object)this.mockFlowNode, (Object)this.declaration.getBeforeTestMuleFlowNode());
    }

    @Test
    public void testSetAndGetAfterTestMuleFlowNode() {
        this.declaration.setAfterTestMuleFlowNode(this.mockFlowNode);
        Assert.assertEquals((Object)this.mockFlowNode, (Object)this.declaration.getAfterTestMuleFlowNode());
    }

    @Test
    public void testSetAndGetBeforeSuiteMuleFlowNode() {
        this.declaration.setBeforeSuiteMuleFlowNode(this.mockFlowNode);
        Assert.assertEquals((Object)this.mockFlowNode, (Object)this.declaration.getBeforeSuiteMuleFlowNode());
    }

    @Test
    public void testSetAndGetAfterSuiteMuleFlowNode() {
        this.declaration.setAfterSuiteMuleFlowNode(this.mockFlowNode);
        Assert.assertEquals((Object)this.mockFlowNode, (Object)this.declaration.getAfterSuiteMuleFlowNode());
    }

    @Test
    public void testOverwriteFlowNodes() {
        MuleFlowNode newMockFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        this.declaration.setBeforeTestMuleFlowNode(this.mockFlowNode);
        this.declaration.setBeforeTestMuleFlowNode(newMockFlowNode);
        Assert.assertEquals((Object)newMockFlowNode, (Object)this.declaration.getBeforeTestMuleFlowNode());
        this.declaration.setAfterTestMuleFlowNode(this.mockFlowNode);
        this.declaration.setAfterTestMuleFlowNode(newMockFlowNode);
        Assert.assertEquals((Object)newMockFlowNode, (Object)this.declaration.getAfterTestMuleFlowNode());
        this.declaration.setBeforeSuiteMuleFlowNode(this.mockFlowNode);
        this.declaration.setBeforeSuiteMuleFlowNode(newMockFlowNode);
        Assert.assertEquals((Object)newMockFlowNode, (Object)this.declaration.getBeforeSuiteMuleFlowNode());
        this.declaration.setAfterSuiteMuleFlowNode(this.mockFlowNode);
        this.declaration.setAfterSuiteMuleFlowNode(newMockFlowNode);
        Assert.assertEquals((Object)newMockFlowNode, (Object)this.declaration.getAfterSuiteMuleFlowNode());
    }

    @Test
    public void testIndependenceOfFlowNodes() {
        MuleFlowNode beforeTestNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MuleFlowNode afterTestNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MuleFlowNode beforeSuiteNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        MuleFlowNode afterSuiteNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        this.declaration.setBeforeTestMuleFlowNode(beforeTestNode);
        this.declaration.setAfterTestMuleFlowNode(afterTestNode);
        this.declaration.setBeforeSuiteMuleFlowNode(beforeSuiteNode);
        this.declaration.setAfterSuiteMuleFlowNode(afterSuiteNode);
        Assert.assertEquals((Object)beforeTestNode, (Object)this.declaration.getBeforeTestMuleFlowNode());
        Assert.assertEquals((Object)afterTestNode, (Object)this.declaration.getAfterTestMuleFlowNode());
        Assert.assertEquals((Object)beforeSuiteNode, (Object)this.declaration.getBeforeSuiteMuleFlowNode());
        Assert.assertEquals((Object)afterSuiteNode, (Object)this.declaration.getAfterSuiteMuleFlowNode());
        Assert.assertNotEquals((Object)beforeTestNode, (Object)this.declaration.getAfterTestMuleFlowNode());
        Assert.assertNotEquals((Object)beforeTestNode, (Object)this.declaration.getBeforeSuiteMuleFlowNode());
        Assert.assertNotEquals((Object)beforeTestNode, (Object)this.declaration.getAfterSuiteMuleFlowNode());
    }

    @Test
    public void testNullAssignment() {
        this.declaration.setBeforeTestMuleFlowNode(this.mockFlowNode);
        this.declaration.setBeforeTestMuleFlowNode(null);
        Assert.assertNull((Object)this.declaration.getBeforeTestMuleFlowNode());
        this.declaration.setAfterTestMuleFlowNode(this.mockFlowNode);
        this.declaration.setAfterTestMuleFlowNode(null);
        Assert.assertNull((Object)this.declaration.getAfterTestMuleFlowNode());
        this.declaration.setBeforeSuiteMuleFlowNode(this.mockFlowNode);
        this.declaration.setBeforeSuiteMuleFlowNode(null);
        Assert.assertNull((Object)this.declaration.getBeforeSuiteMuleFlowNode());
        this.declaration.setAfterSuiteMuleFlowNode(this.mockFlowNode);
        this.declaration.setAfterSuiteMuleFlowNode(null);
        Assert.assertNull((Object)this.declaration.getAfterSuiteMuleFlowNode());
    }
}

