/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class AstNotificationTest {
    @Test
    public void test() {
        AstNotification astNotification = new AstNotification();
        AstNodeLocation astNodeLocation = new AstNodeLocation(DefaultComponentLocation.from((String)"/flow/processors/0"));
        astNotification.reportFatalError(astNodeLocation, I18nMessageFactory.createStaticMessage((String)"test message %s", (Object[])new Object[]{"FATAL-ERROR"}));
        astNotification.reportError(astNodeLocation, I18nMessageFactory.createStaticMessage((String)"test message %s", (Object[])new Object[]{"ERROR"}));
        astNotification.reportWarning(astNodeLocation, I18nMessageFactory.createStaticMessage((String)"test message %s", (Object[])new Object[]{"WARNING"}));
        astNotification.reportInfo(astNodeLocation, I18nMessageFactory.createStaticMessage((String)"test message %s", (Object[])new Object[]{"INFO"}));
    }

    @Test
    public void testGenericMethods() {
        AstNotification astNotification = new AstNotification();
        astNotification.reportFatalError((I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportFatalError((AstNodeLocation)Mockito.mock(AstNodeLocation.class), (I18nMessage)Mockito.mock(I18nMessage.class), FailureCode.CONNECTION_FAILURE, MetadataComponent.COMPONENT, "abc", (I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportError((I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportError((AstNodeLocation)Mockito.mock(AstNodeLocation.class), (I18nMessage)Mockito.mock(I18nMessage.class), FailureCode.CONNECTION_FAILURE, MetadataComponent.COMPONENT, "abc", (I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportWarning((I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportWarning((AstNodeLocation)Mockito.mock(AstNodeLocation.class), (I18nMessage)Mockito.mock(I18nMessage.class), FailureCode.CONNECTION_FAILURE, MetadataComponent.COMPONENT, "abc", (I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportInfo((I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportDebug((I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.reportDebug((AstNodeLocation)Mockito.mock(AstNodeLocation.class), (I18nMessage)Mockito.mock(I18nMessage.class));
        astNotification.hasErrors();
        astNotification.hasWarnings();
        astNotification.hasFatalErrors();
        Assert.assertNotNull((Object)astNotification);
    }
}

