/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.event.Expr;
import org.mule.datasense.impl.model.event.MessageExpr;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MessageExprTest {
    @Mock
    private Expr mockPayloadExpr;
    @Mock
    private Expr mockAttributesExpr;
    @Mock
    private MuleEventMetadataType mockMuleEventMetadataType;
    @Mock
    private ResolveTypeContext mockResolveTypeContext;
    @Mock
    private MessageMetadataTypeBuilder mockMessageMetadataTypeBuilder;
    @Mock
    private MessageMetadataType mockBuiltMessageMetadataType;
    @Mock
    private MetadataType mockPayloadType;
    @Mock
    private MetadataType mockAttributesType;
    @Mock
    private MuleEventMetadataTypeBuilder mockMuleEventMetadataTypeBuilder;
    @Mock
    private MessageMetadataType mockMessageMetadataType;
    private MessageExpr messageExpr;

    @Before
    public void setUp() {
        this.messageExpr = new MessageExpr(this.mockPayloadExpr, this.mockAttributesExpr);
        Mockito.when((Object)this.mockPayloadExpr.resolveType((MuleEventMetadataType)ArgumentMatchers.any(), (ResolveTypeContext)ArgumentMatchers.any())).thenReturn((Object)this.mockPayloadType);
        Mockito.when((Object)this.mockAttributesExpr.resolveType((MuleEventMetadataType)ArgumentMatchers.any(), (ResolveTypeContext)ArgumentMatchers.any())).thenReturn((Object)this.mockAttributesType);
        Mockito.when((Object)this.mockMessageMetadataType.getPayloadType()).thenReturn(Optional.of(this.mockPayloadType));
        Mockito.when((Object)this.mockMessageMetadataType.getAttributesType()).thenReturn(Optional.of(this.mockAttributesType));
    }

    @Test
    public void testResolveType() {
        MessageMetadataType result = this.messageExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertNotNull((Object)result);
        ((Expr)Mockito.verify((Object)this.mockPayloadExpr)).resolveType((MuleEventMetadataType)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataType), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
        ((Expr)Mockito.verify((Object)this.mockAttributesExpr)).resolveType((MuleEventMetadataType)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataType), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
    }

    @Test
    public void testResolveInputType() {
        this.messageExpr.resolveInputType(this.mockMuleEventMetadataTypeBuilder, (MetadataType)this.mockMessageMetadataType, this.mockResolveTypeContext);
        ((Expr)Mockito.verify((Object)this.mockPayloadExpr)).resolveInputType((MetadataType)ArgumentMatchers.any(MetadataType.class), (MuleEventMetadataTypeBuilder)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataTypeBuilder), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
        ((Expr)Mockito.verify((Object)this.mockAttributesExpr)).resolveInputType((MetadataType)ArgumentMatchers.any(MetadataType.class), (MuleEventMetadataTypeBuilder)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataTypeBuilder), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
    }

    @Test
    public void testResolveInputTypeWithNonMessageType() {
        MetadataType nonMessageType = (MetadataType)Mockito.mock(MetadataType.class);
        this.messageExpr.resolveInputType(this.mockMuleEventMetadataTypeBuilder, nonMessageType, this.mockResolveTypeContext);
        ((Expr)Mockito.verify((Object)this.mockPayloadExpr)).resolveInputType((MetadataType)ArgumentMatchers.any(MetadataType.class), (MuleEventMetadataTypeBuilder)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataTypeBuilder), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
        ((Expr)Mockito.verify((Object)this.mockAttributesExpr)).resolveInputType((MetadataType)ArgumentMatchers.any(MetadataType.class), (MuleEventMetadataTypeBuilder)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataTypeBuilder), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
    }

    @Test
    public void testConstructorWithNullValues() {
        MessageExpr emptyMessageExpr = new MessageExpr(null, null);
        emptyMessageExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        emptyMessageExpr.resolveInputType(this.mockMuleEventMetadataTypeBuilder, (MetadataType)this.mockMessageMetadataType, this.mockResolveTypeContext);
    }
}

