/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.event.DefElem;
import org.mule.datasense.impl.model.event.MuleEventExpr;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MuleEventExprTest {
    @Mock
    private DefElem mockDefElem1;
    @Mock
    private DefElem mockDefElem2;
    @Mock
    private MuleEventMetadataType mockMuleEventMetadataType;
    @Mock
    private MuleEventMetadataTypeBuilder mockMuleEventMetadataTypeBuilder;
    @Mock
    private MuleEventMetadataType mockBuiltMuleEventMetadataType;
    @Mock
    private ResolveTypeContext mockResolveTypeContext;
    @Mock
    private MessageMetadataType mockMessageMetadataType;
    private MuleEventExpr muleEventExpr;

    @Before
    public void setUp() {
        List<DefElem> defElems = Arrays.asList(this.mockDefElem1, this.mockDefElem2);
        this.muleEventExpr = new MuleEventExpr(defElems);
        Mockito.when((Object)this.mockMuleEventMetadataTypeBuilder.build()).thenReturn((Object)this.mockBuiltMuleEventMetadataType);
        Mockito.when((Object)this.mockMuleEventMetadataType.getMessageType()).thenReturn((Object)this.mockMessageMetadataType);
    }

    @Test
    public void testResolveType() {
        MuleEventMetadataType result = this.muleEventExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertNotNull((Object)result);
        ((DefElem)Mockito.verify((Object)this.mockDefElem1)).resolveType((MuleEventMetadataTypeBuilder)ArgumentMatchers.any(MuleEventMetadataTypeBuilder.class), (MuleEventMetadataType)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataType), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
        ((DefElem)Mockito.verify((Object)this.mockDefElem2)).resolveType((MuleEventMetadataTypeBuilder)ArgumentMatchers.any(MuleEventMetadataTypeBuilder.class), (MuleEventMetadataType)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataType), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
    }

    @Test
    public void testResolveInputType() {
        MuleEventMetadataType result = this.muleEventExpr.resolveInputType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertNotNull((Object)result);
        ((DefElem)Mockito.verify((Object)this.mockDefElem1)).resolveInputType((MuleEventMetadataTypeBuilder)ArgumentMatchers.any(MuleEventMetadataTypeBuilder.class), (MuleEventMetadataType)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataType), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
        ((DefElem)Mockito.verify((Object)this.mockDefElem2)).resolveInputType((MuleEventMetadataTypeBuilder)ArgumentMatchers.any(MuleEventMetadataTypeBuilder.class), (MuleEventMetadataType)ArgumentMatchers.eq((Object)this.mockMuleEventMetadataType), (ResolveTypeContext)ArgumentMatchers.eq((Object)this.mockResolveTypeContext));
    }

    @Test
    public void testWithEmptyDefinitions() {
        MuleEventExpr emptyMuleEventExpr = new MuleEventExpr(Collections.emptyList());
        MuleEventMetadataType result = emptyMuleEventExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertNotNull((Object)result);
        result = emptyMuleEventExpr.resolveInputType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertNotNull((Object)result);
    }
}

