/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

@RunWith(value=Parameterized.class)
public class EventTypesUnionTest {
    private final String name;
    private List<EventType> argumentEventTypes;
    private String expectedMetadataType;

    public EventTypesUnionTest(String name, List<EventType> argumentEventTypes, String expectedMetadataType) {
        this.name = name;
        this.argumentEventTypes = argumentEventTypes;
        this.expectedMetadataType = expectedMetadataType;
    }

    private static List<EventType> eventTypes(Consumer<MuleEventMetadataTypeBuilder> ... consumers) {
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        Arrays.asList(consumers).forEach(muleEventMetadataTypeBuilderConsumer -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilderConsumer.accept(muleEventMetadataTypeBuilder);
            eventTypes.add(TypeUtils.asEventType((MuleEventMetadataType)muleEventMetadataTypeBuilder.build()));
        });
        return eventTypes;
    }

    private static List<Object[]> basicTests() {
        String testGroup = "basic.test-";
        return Arrays.asList(new Object[][]{{testGroup + "empty", EventTypesUnionTest.eventTypes(new Consumer[0]), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}"}});
    }

    private static List<Object[]> basicTestsOnPayloads() {
        String testGroup = "basic.test.on.payloads-";
        return Arrays.asList({testGroup + "simple.type", EventTypesUnionTest.eventTypes(m -> m.message().payload().stringType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {testGroup + "simple.union", EventTypesUnionTest.eventTypes(m -> m.message().payload().stringType(), m -> m.message().payload().numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}"}, {testGroup + "simple.union.with.repetition", EventTypesUnionTest.eventTypes(m -> m.message().payload().stringType(), m -> m.message().payload().stringType(), m -> m.message().payload().numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}"});
    }

    private static List<Object[]> basicTestsOnAttributes() {
        String testGroup = "basic.test.on.payloads-";
        return Arrays.asList({testGroup + "simple.type", EventTypesUnionTest.eventTypes(m -> m.message().attributes().stringType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {testGroup + "simple.union", EventTypesUnionTest.eventTypes(m -> m.message().attributes().stringType(), m -> m.message().attributes().numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}"}, {testGroup + "simple.union.with.repetition", EventTypesUnionTest.eventTypes(m -> m.message().attributes().stringType(), m -> m.message().attributes().stringType(), m -> m.message().attributes().numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}"});
    }

    private static List<Object[]> basicTestsOnVars() {
        String testGroup = "basic.test.on.payloads-";
        return Arrays.asList({testGroup + "simple.type", EventTypesUnionTest.eventTypes(m -> m.addVariable("v1").stringType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String\n  }\n}"}, {testGroup + "simple.union", EventTypesUnionTest.eventTypes(m -> m.addVariable("v1").stringType(), m -> m.addVariable("v1").numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String | Number\n  }\n}"}, {testGroup + "simple.union.with.repetition", EventTypesUnionTest.eventTypes(m -> m.addVariable("v1").stringType(), m -> m.addVariable("v1").stringType(), m -> m.addVariable("v1").numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\" : String | Number\n  }\n}"});
    }

    private static List<Object[]> combinations() {
        String testGroup = "basic.test.on.payloads-";
        return Arrays.asList({testGroup + "simple.union", EventTypesUnionTest.eventTypes(m -> m.addVariable("v1").stringType(), m -> m.addVariable("v2").numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"v1\"? : String, \n    \"v2\"? : Number\n  }\n}"}, {testGroup + "simple.union.with.repetition", EventTypesUnionTest.eventTypes(m -> m.message().payload().stringType(), m -> m.addVariable("v1").stringType(), m -> m.message().attributes().numberType()), "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String, \n    \"attributes\" : Number\n  }, \n  \"variables\" : {\n    \"v1\"? : String\n  }\n}"});
    }

    @Parameterized.Parameters(name="{0}-{index}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(EventTypesUnionTest.basicTests());
        parameters.addAll(EventTypesUnionTest.basicTestsOnPayloads());
        parameters.addAll(EventTypesUnionTest.basicTestsOnAttributes());
        parameters.addAll(EventTypesUnionTest.basicTestsOnVars());
        parameters.addAll(EventTypesUnionTest.combinations());
        return parameters;
    }

    @Test
    public void unionTest() {
        EventType eventType = TypeUtils.union(this.argumentEventTypes, (ExpressionLanguageMetadataService)ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
        Assert.assertNotNull((Object)eventType);
        Assert.assertThat((Object)TypeUtils.asMuleEventMetadataType((EventType)eventType).build(), (Matcher)new MetadataTypeMatcher.IsAs(this.expectedMetadataType));
    }
}

