/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.util.MetadataTypeWriter;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataTypeWriterTest {
    MetadataTypeWriter metadataTypeWriter;

    @Before
    public void setup() {
        this.metadataTypeWriter = new MetadataTypeWriter();
    }

    @Test
    public void testWrite() throws NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Stack<MetadataType> stack = new Stack<MetadataType>();
        stack.push(metadataType);
        Method method = MetadataTypeWriter.class.getDeclaredMethod("write", MetadataType.class);
        method.setAccessible(true);
        Field field = MetadataTypeWriter.class.getDeclaredField("typeStack");
        field.setAccessible(true);
        field.set(this.metadataTypeWriter, stack);
        method.invoke((Object)this.metadataTypeWriter, metadataType);
        Assert.assertNotNull((Object)metadataType);
    }

    @Test
    public void testWriteAttributes() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ObjectKeyType objectKeyType = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        AttributeFieldType attributeFieldType = (AttributeFieldType)Mockito.mock(AttributeFieldType.class);
        Mockito.when((Object)objectKeyType.getAttributes()).thenReturn(Arrays.asList(attributeFieldType));
        Mockito.when((Object)attributeFieldType.getKey()).thenReturn((Object)((AttributeKeyType)Mockito.mock(AttributeKeyType.class)));
        Mockito.when((Object)attributeFieldType.getKey().isName()).thenReturn((Object)false);
        Mockito.when((Object)attributeFieldType.getKey().isPattern()).thenReturn((Object)false);
        Mockito.when((Object)attributeFieldType.getValue()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Method method = MetadataTypeWriter.class.getDeclaredMethod("writeAttributes", ObjectKeyType.class);
        method.setAccessible(true);
        method.invoke((Object)this.metadataTypeWriter, objectKeyType);
        Assert.assertNotNull((Object)objectKeyType);
    }

    @Test
    public void testWriteObject() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ObjectType objectType = (ObjectType)Mockito.mock(ObjectType.class);
        Method method = MetadataTypeWriter.class.getDeclaredMethod("writeObject", ObjectType.class);
        method.setAccessible(true);
        Mockito.when((Object)objectType.isOrdered()).thenReturn((Object)true);
        ObjectFieldType fieldType = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectKeyType keyType = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)fieldType.getKey()).thenReturn((Object)keyType);
        Mockito.when((Object)objectType.getFields()).thenReturn(Arrays.asList(fieldType));
        Mockito.when((Object)keyType.isPattern()).thenReturn((Object)true);
        Mockito.when((Object)keyType.getPattern()).thenReturn((Object)Pattern.compile("abc"));
        Mockito.when((Object)fieldType.isRepeated()).thenReturn((Object)true);
        Mockito.when((Object)objectType.getOpenRestriction()).thenReturn(Optional.of((MetadataType)Mockito.mock(MetadataType.class)));
        Mockito.when((Object)fieldType.getValue()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        method.invoke((Object)this.metadataTypeWriter, objectType);
        Assert.assertNotNull((Object)this.metadataTypeWriter);
    }
}

