/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.phases.builder.ApplicationResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.ComponentModelClassifier;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasenseapi.api.ApplicationResolutionScope;
import org.mule.datasenseapi.api.DataSenseResolutionScope;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleAstParserContextTest {
    @Mock
    private ApplicationModel applicationModel;
    @Mock
    private DataSenseProvider dataSenseProvider;
    @Mock
    private ComponentModelClassifier componentModelClassifier;
    @Mock
    private TypeResolverRegistry typeResolverRegistry;
    @Mock
    private ComponentAst componentAst;
    @Mock
    private ComponentIdentifier componentIdentifier;
    private MuleAstParserContext context;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.componentAst.getIdentifier()).thenReturn((Object)this.componentIdentifier);
        Mockito.when((Object)this.componentIdentifier.toString()).thenReturn((Object)"test-component");
    }

    @Test
    public void testConstructorWithoutResolutionScope() {
        this.context = new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, this.componentModelClassifier);
        Assert.assertNotNull((Object)this.context);
        Assert.assertFalse((boolean)this.context.getDataSenseResolutionScopeStrategy().isPresent());
    }

    @Test
    public void testConstructorWithResolutionScope() {
        DataSenseResolutionScope resolutionScope = (DataSenseResolutionScope)Mockito.mock(ApplicationResolutionScope.class);
        this.context = new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, this.componentModelClassifier, resolutionScope, this.typeResolverRegistry);
        Assert.assertNotNull((Object)this.context);
        Assert.assertTrue((boolean)this.context.getDataSenseResolutionScopeStrategy().isPresent());
    }

    @Test
    public void testEnterAndExitMethods() {
        this.context = new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, this.componentModelClassifier);
        this.context.enter(this.componentAst);
        this.context.exit(this.componentAst);
    }

    @Test
    public void testGetParseProvider() {
        this.context = new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, this.componentModelClassifier, null, this.typeResolverRegistry);
        TypeResolver typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        MuleAstParseProvider parseProvider = (MuleAstParseProvider)Mockito.mock(MuleAstParseProvider.class);
        Mockito.when((Object)this.typeResolverRegistry.get(this.componentIdentifier)).thenReturn(Optional.of(typeResolver));
        Mockito.when((Object)typeResolver.getParseProvider()).thenReturn(Optional.of(parseProvider));
        Optional result = this.context.getParseProvider(this.componentAst);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)parseProvider, result.get());
    }

    @Test
    public void testCreateDataSenseResolutionScopeStrategyWithApplicationScope() {
        ApplicationResolutionScope applicationScope = (ApplicationResolutionScope)Mockito.mock(ApplicationResolutionScope.class);
        this.context = new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, this.componentModelClassifier, (DataSenseResolutionScope)applicationScope, this.typeResolverRegistry);
        Assert.assertTrue((boolean)this.context.getDataSenseResolutionScopeStrategy().isPresent());
        Assert.assertTrue((boolean)(this.context.getDataSenseResolutionScopeStrategy().get() instanceof ApplicationResolutionScopeStrategy));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateDataSenseResolutionScopeStrategyWithUnknownScope() {
        DataSenseResolutionScope unknownScope = (DataSenseResolutionScope)Mockito.mock(DataSenseResolutionScope.class);
        new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, this.componentModelClassifier, unknownScope, this.typeResolverRegistry);
    }
}

