/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.DataSenseResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.builder.MuleAstParser;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.builder.MuleFlowNodeBuilder;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleAstParserTest {
    private MuleAstParser parser;
    private ComponentAst componentModel;
    private MuleAstParserContext muleAstParserContext;

    @Before
    public void setUp() {
        this.parser = new MuleAstParser();
        this.componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.muleAstParserContext = (MuleAstParserContext)Mockito.mock(MuleAstParserContext.class);
    }

    @Test
    public void testParseFlowComponent() {
        ComponentIdentifier flowIdentifier = DefaultDataSense.COMPONENT_IDENTIFIER_FLOW;
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)flowIdentifier);
        Mockito.when((Object)this.componentModel.getComponentId()).thenReturn(Optional.of("flowId"));
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.empty());
        ComponentModelType componentModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
        Mockito.when((Object)this.muleAstParserContext.astlogger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.muleAstParserContext.getComponentModelType(this.componentModel)).thenReturn(Optional.of(componentModelType));
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.of((ComponentAst)Mockito.mock(ComponentAst.class)));
        Optional result = this.parser.parse(this.componentModel, this.muleAstParserContext);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)(result.get() instanceof MuleFlowNodeBuilder));
    }

    @Test
    public void testParseNonFlowComponent() {
        ComponentIdentifier nonFlowIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)nonFlowIdentifier);
        Mockito.when((Object)this.muleAstParserContext.astlogger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.muleAstParserContext.getParseProvider(this.componentModel)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.empty());
        Optional result = this.parser.parse(this.componentModel, this.muleAstParserContext);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testParseUnknownComponent() {
        ComponentIdentifier unknownIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)unknownIdentifier);
        Mockito.when((Object)this.muleAstParserContext.astlogger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.muleAstParserContext.getComponentModelType(this.componentModel)).thenReturn(Optional.empty());
        Optional result = this.parser.parse(this.componentModel, this.muleAstParserContext);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testParseWithCustomParseProvider() {
        ComponentIdentifier customIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)customIdentifier);
        Mockito.when((Object)this.muleAstParserContext.astlogger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        MuleAstParseProvider customProvider = (MuleAstParseProvider)Mockito.mock(MuleAstParseProvider.class);
        Mockito.when((Object)this.muleAstParserContext.getParseProvider(this.componentModel)).thenReturn(Optional.of(customProvider));
        AstNodeBuilder customBuilder = (AstNodeBuilder)Mockito.mock(AstNodeBuilder.class);
        Mockito.when((Object)customProvider.parse((ComponentIdentifier)Mockito.any(), (ComponentAst)Mockito.any(), (ComponentModelType)Mockito.any(), (List)Mockito.any(), (MuleAstParserContext)Mockito.any())).thenReturn(Optional.of(customBuilder));
        Optional result = this.parser.parse(this.componentModel, this.muleAstParserContext);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testParseErrorHandler() {
        ComponentIdentifier errorHandlerIdentifier = DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER;
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)errorHandlerIdentifier);
        Mockito.when((Object)this.componentModel.getComponentId()).thenReturn(Optional.of("errorHandlerId"));
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.empty());
        Optional result = this.parser.parse(this.componentModel, this.muleAstParserContext);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)(result.get() instanceof MuleFlowNodeBuilder));
        ((MuleAstParserContext)Mockito.verify((Object)this.muleAstParserContext)).getComponentModelType(this.componentModel);
    }

    @Test
    public void testParseWithDataSenseResolutionScopeStrategy() {
        ComponentIdentifier flowIdentifier = DefaultDataSense.COMPONENT_IDENTIFIER_FLOW;
        Mockito.when((Object)this.componentModel.getIdentifier()).thenReturn((Object)flowIdentifier);
        Mockito.when((Object)this.componentModel.getComponentId()).thenReturn(Optional.of("flowId"));
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.empty());
        DataSenseResolutionScopeStrategy strategy = (DataSenseResolutionScopeStrategy)Mockito.mock(DataSenseResolutionScopeStrategy.class);
        Mockito.when((Object)this.muleAstParserContext.getDataSenseResolutionScopeStrategy()).thenReturn(Optional.of(strategy));
        Mockito.when((Object)strategy.match(this.componentModel)).thenReturn((Object)false);
        Optional result = this.parser.parse(this.componentModel, this.muleAstParserContext);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)(result.get() instanceof MuleFlowNodeBuilder));
        ((DataSenseResolutionScopeStrategy)Mockito.verify((Object)strategy)).match(this.componentModel);
    }

    @Test
    public void testGetAstNodeBuilder() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = MuleAstParser.class.getDeclaredMethod("getAstNodeBuilder", ComponentAst.class, MuleAstParserContext.class, ComponentIdentifier.class);
        method.setAccessible(true);
        ComponentIdentifier componentIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentModelType componentModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
        Mockito.when((Object)this.muleAstParserContext.astlogger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.muleAstParserContext.getComponentModelType(this.componentModel)).thenReturn(Optional.of(componentModelType));
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.of((ComponentAst)Mockito.mock(ComponentAst.class)));
        Optional result = (Optional)method.invoke((Object)this.parser, this.componentModel, this.muleAstParserContext, componentIdentifier);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetAstNodeBuilderParseProvider() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = MuleAstParser.class.getDeclaredMethod("getAstNodeBuilder", ComponentAst.class, MuleAstParserContext.class, ComponentIdentifier.class);
        method.setAccessible(true);
        ComponentIdentifier componentIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentModelType componentModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
        Mockito.when((Object)this.muleAstParserContext.astlogger()).thenReturn((Object)((TreeLogSupport)Mockito.mock(TreeLogSupport.class)));
        Mockito.when((Object)this.muleAstParserContext.getComponentModelType(this.componentModel)).thenReturn(Optional.of(componentModelType));
        Mockito.when((Object)this.componentModel.directChildrenStream()).thenReturn(Stream.of((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.muleAstParserContext.getParseProvider(this.componentModel)).thenReturn(Optional.of((MuleAstParseProvider)Mockito.mock(MuleAstParseProvider.class)));
        Optional result = (Optional)method.invoke((Object)this.parser, this.componentModel, this.muleAstParserContext, componentIdentifier);
        Assert.assertNotNull((Object)result);
    }
}

