/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleFlowNodeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleFlowNodeBuilderTest {
    @Mock
    private ComponentIdentifier mockComponentIdentifier;
    @Mock
    private ComponentAst mockComponentModel;
    @Mock
    private MessageProcessorNodeBuilder mockMessageProcessorNodeBuilder;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    private MuleFlowNodeBuilder muleFlowNodeBuilder;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.muleFlowNodeBuilder = new MuleFlowNodeBuilder(this.mockComponentIdentifier);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.muleFlowNodeBuilder);
    }

    @Test
    public void testConfig() {
        MuleFlowNodeBuilder result = this.muleFlowNodeBuilder.config(this.mockComponentModel);
        Assert.assertEquals((Object)this.muleFlowNodeBuilder, (Object)result);
    }

    @Test
    public void testMessageProcessorWithConsumer() {
        MuleFlowNodeBuilder result = this.muleFlowNodeBuilder.messageProcessor(this.mockComponentIdentifier, builder -> {});
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testMessageProcessorWithBuilder() {
        MuleFlowNodeBuilder result = this.muleFlowNodeBuilder.messageProcessor(this.mockMessageProcessorNodeBuilder);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNodeBuilder)Mockito.verify((Object)this.mockMessageProcessorNodeBuilder)).root();
    }

    @Test
    public void testBuildWithMessageProcessor() {
        Mockito.when((Object)this.mockMessageProcessorNodeBuilder.build()).thenReturn((Object)this.mockMessageProcessorNode);
        this.muleFlowNodeBuilder.config(this.mockComponentModel);
        this.muleFlowNodeBuilder.messageProcessor(this.mockMessageProcessorNodeBuilder);
        MuleFlowNode result = this.muleFlowNodeBuilder.build();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockComponentIdentifier, (Object)result.getIdentifier());
        Assert.assertEquals((Object)this.mockComponentModel, (Object)result.getComponentModel());
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).setParentAstNode((AstNode)result);
    }

    @Test
    public void testBuildWithoutMessageProcessor() {
        this.muleFlowNodeBuilder.config(this.mockComponentModel);
        MuleFlowNode result = this.muleFlowNodeBuilder.build();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockComponentIdentifier, (Object)result.getIdentifier());
        Assert.assertEquals((Object)this.mockComponentModel, (Object)result.getComponentModel());
    }
}

