/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.resolver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.AggregatorTypeResolver;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class AggregatorTypeResolverTest {
    private AggregatorTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private EventType inputEventType;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;

    @Before
    public void setUp() {
        this.resolver = new AggregatorTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.inputEventType = (EventType)Mockito.mock(EventType.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testAggregatorAttributesType() {
        MetadataType result = AggregatorTypeResolver.aggregatorAttributesType();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testResolve() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = AggregatorTypeResolver.class.getDeclaredMethod("resolve", MessageProcessorNode.class, EventType.class, TypingMuleAstVisitor.class, TypingMuleAstVisitorContext.class);
        method.setAccessible(true);
        EventType result = (EventType)method.invoke((Object)this.resolver, this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testIsPropagates() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AggregatorTypeResolver.class.getDeclaredMethod("isPropagates", MessageProcessorNode.class);
        method.setAccessible(true);
        Assert.assertTrue((boolean)((Boolean)method.invoke((Object)this.resolver, this.messageProcessorNode)));
    }

    @Test
    public void testIsSequential() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = AggregatorTypeResolver.class.getDeclaredMethod("isSequential", new Class[0]);
        method.setAccessible(true);
        Assert.assertFalse((boolean)((Boolean)method.invoke((Object)this.resolver, new Object[0])));
    }

    @Test
    public void testGetContentParameterValue() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter("Aggregator config", "content")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Method method = AggregatorTypeResolver.class.getDeclaredMethod("getContentParameterValue", MessageProcessorNode.class);
        method.setAccessible(true);
        Either result = (Either)method.invoke((Object)this.resolver, this.messageProcessorNode);
        Assert.assertNull((Object)result);
    }
}

