/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import org.junit.Test;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.BaseDwExpressionMetadataResolverTest;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class DwExpressionMetadataResolverTest
extends BaseDwExpressionMetadataResolverTest {
    @Test
    public void verifyExpectedEventFromExpression_1() {
        String expression = "payload";
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = MuleEventMetadataType.builder();
        muleEventMetadataTypeBuilder.message().payload().anyType();
        this.verifyExpectedEventTypeForProvidedScript(expression, muleEventMetadataTypeBuilder, (MetadataType)TypesHelper.getTypeBuilder().anyType().build());
    }

    @Test
    public void verifyExpectedEventFromExpression_2() {
        String expression = "attributes";
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = MuleEventMetadataType.builder();
        muleEventMetadataTypeBuilder.message().attributes().anyType();
        this.verifyExpectedEventTypeForProvidedScript(expression, muleEventMetadataTypeBuilder, (MetadataType)TypesHelper.getTypeBuilder().anyType().build());
    }

    @Test
    public void verifyExpectedEventFromExpression_3() {
        String expression = "vars.var1";
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = MuleEventMetadataType.builder();
        muleEventMetadataTypeBuilder.addVariable("var1").anyType();
        this.verifyExpectedEventTypeForProvidedScript(expression, muleEventMetadataTypeBuilder, (MetadataType)TypesHelper.getTypeBuilder().anyType().build());
    }

    @Test
    public void verifyOutputTypeFromExpression_1() {
        String expression = "payload";
        MuleEventMetadataTypeBuilder inputEventTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        inputEventTypeBuilder.message().payload().stringType();
        BaseTypeBuilder expectedOutputTypeBuilder = TypesHelper.getTypeBuilder();
        expectedOutputTypeBuilder.stringType();
        this.verifyExpectedOutputForProvidedExpression(expression, inputEventTypeBuilder, expectedOutputTypeBuilder);
    }

    @Test
    public void verifyOutputTypeFromExpression_3() {
        String expression = "vars.var1 ++ vars.var2";
        MuleEventMetadataTypeBuilder inputEventTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        inputEventTypeBuilder.addVariable("var1").stringType();
        inputEventTypeBuilder.addVariable("var2").stringType();
        BaseTypeBuilder expectedOutputTypeBuilder = TypesHelper.getTypeBuilder();
        expectedOutputTypeBuilder.stringType();
        this.verifyExpectedOutputForProvidedExpression(expression, inputEventTypeBuilder, expectedOutputTypeBuilder);
    }

    @Test
    public void verifyOutputTypeFromExpression_4() {
        String expression = "{\n    name: payload,\n    foo: vars.foo,\n    bar: vars[\"bar\"]\n}\n";
        MuleEventMetadataTypeBuilder inputEventTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        inputEventTypeBuilder.message().payload().stringType();
        inputEventTypeBuilder.addVariable("foo").stringType();
        inputEventTypeBuilder.addVariable("bar").stringType();
        BaseTypeBuilder expectedOutputTypeBuilder = TypesHelper.getTypeBuilder();
        ObjectTypeBuilder objectTypeBuilder = expectedOutputTypeBuilder.objectType();
        objectTypeBuilder.addField().required(true).key("name").value().stringType();
        objectTypeBuilder.addField().required(true).key("foo").value().stringType();
        objectTypeBuilder.addField().required(true).key("bar").value().stringType();
        this.verifyExpectedOutputForProvidedExpression(expression, inputEventTypeBuilder, expectedOutputTypeBuilder);
    }
}

