/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.AggregatorRouteTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class AggregatorRouteTypeResolverTest {
    private AggregatorRouteTypeResolver resolver;

    @Before
    public void setUp() {
        this.resolver = new AggregatorRouteTypeResolver();
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testIsPropagates() {
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Assert.assertTrue((boolean)this.resolver.isPropagates(mockNode));
    }

    @Test
    public void testGetParseProvider() {
        Optional result = this.resolver.getParseProvider();
        Assert.assertTrue((boolean)result.isPresent());
    }

    @Test
    public void testGenerateAst() {
        ComponentIdentifier mockIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentAst mockComponentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentModelType mockModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
        ArrayList mockBuilders = new ArrayList();
        Optional parseProviderOptional = this.resolver.getParseProvider();
        Assert.assertTrue((boolean)parseProviderOptional.isPresent());
        MuleAstParseProvider parseProvider = (MuleAstParseProvider)parseProviderOptional.get();
        Optional result = parseProvider.parse(mockIdentifier, mockComponentModel, mockModelType, mockBuilders, null);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull(result.get());
    }

    @Test
    public void testScopeInResolve() {
        AggregatorRouteTypeResolver.ScopeIn scopeIn = new AggregatorRouteTypeResolver.ScopeIn();
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        EventType mockInputEventType = (EventType)Mockito.mock(EventType.class);
        TypingMuleAstVisitor mockVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        TypingMuleAstVisitorContext mockContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        EventType result = scopeIn.resolve(mockNode, mockInputEventType, mockVisitor, mockContext);
        Assert.assertEquals((Object)mockInputEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)mockNode, (VerificationMode)Mockito.times((int)2))).annotate((AstNodeAnnotation)Mockito.any());
    }

    @Test
    public void testScopeInGenerateExpected() {
        AggregatorRouteTypeResolver.ScopeIn scopeIn = new AggregatorRouteTypeResolver.ScopeIn();
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        ExpectedAstVisitor mockVisitor = (ExpectedAstVisitor)Mockito.mock(ExpectedAstVisitor.class);
        ExpectedAstVisitorContext mockContext = (ExpectedAstVisitorContext)Mockito.mock(ExpectedAstVisitorContext.class);
        EventType mockExpectedEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)mockContext.getExpectedEventType()).thenReturn((Object)mockExpectedEventType);
        EventType result = scopeIn.generateExpected(mockNode, mockVisitor, mockContext);
        Assert.assertEquals((Object)mockExpectedEventType, (Object)result);
    }

    @Test
    public void testScopeInIsPropagates() {
        AggregatorRouteTypeResolver.ScopeIn scopeIn = new AggregatorRouteTypeResolver.ScopeIn();
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Assert.assertTrue((boolean)scopeIn.isPropagates(mockNode));
    }
}

