/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.phases.typing.resolver.ChoiceTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.DataSenseTypeResolverRegistry;
import org.mule.datasense.impl.phases.typing.resolver.ErrorHandlerTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.FlowTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.ForEachTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.LoggerTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.RaiseErrorTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.RemoveVariableTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetPayloadTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetVariableTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.UnknownProcessorTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;

public class DataSenseTypeResolverRegistryTest {
    private DataSenseTypeResolverRegistry registry;

    @Before
    public void setup() {
        this.registry = new DataSenseTypeResolverRegistry();
    }

    @Test
    public void testFlowTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_FLOW);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof FlowTypeResolver));
    }

    @Test
    public void testLoggerTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_LOGGER);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof LoggerTypeResolver));
    }

    @Test
    public void testSetPayloadTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof SetPayloadTypeResolver));
    }

    @Test
    public void testSetVariableTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_SET_VARIABLE);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof SetVariableTypeResolver));
    }

    @Test
    public void testRemoveVariableTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_REMOVE_VARIABLE);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof RemoveVariableTypeResolver));
    }

    @Test
    public void testErrorHandlerTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof ErrorHandlerTypeResolver));
    }

    @Test
    public void testChoiceTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_CHOICE);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof ChoiceTypeResolver));
    }

    @Test
    public void testForEachTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof ForEachTypeResolver));
    }

    @Test
    public void testRaiseErrorTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_RAISE_ERROR);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof RaiseErrorTypeResolver));
    }

    @Test
    public void testUnknownProcessorTypeResolverRegistration() {
        Optional typeResolver = this.registry.get(DefaultDataSense.COMPONENT_IDENTIFIER_UNKNOWN_PROCESSOR);
        Assert.assertTrue((boolean)typeResolver.isPresent());
        Assert.assertTrue((boolean)(typeResolver.get() instanceof UnknownProcessorTypeResolver));
    }

    @Test
    public void testNonExistentComponentIdentifier() {
        Optional typeResolver = this.registry.get(ComponentIdentifier.builder().namespace("non").name("existent").build());
        Assert.assertTrue((!typeResolver.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testNullComponentIdentifier() {
        Optional typeResolver = this.registry.get(null);
        Assert.assertTrue((!typeResolver.isPresent() ? 1 : 0) != 0);
    }
}

