/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ErrorHandlerTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingEnvironment;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ErrorHandlerTypeResolverTest {
    private ErrorHandlerTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private ComponentAst componentModel;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext visitorContext;
    @Mock
    private MessageProcessorNode childProcessor1;
    @Mock
    private MessageProcessorNode childProcessor2;
    @Mock
    private ErrorHandlingEnvironment errorHandlingEnvironment;
    @Mock
    private ErrorHandlingContext errorHandlingContext;

    @Before
    public void setup() {
        this.resolver = new ErrorHandlerTypeResolver();
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.of(this.childProcessor1, this.childProcessor2));
        Mockito.when((Object)this.visitorContext.getErrorHandlingEnvironment()).thenReturn((Object)this.errorHandlingEnvironment);
        Mockito.when((Object)this.errorHandlingEnvironment.getContext()).thenReturn((Object)this.errorHandlingContext);
    }

    @Test
    public void testGetComponentModelType() {
        Optional componentModelType = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)componentModelType.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, componentModelType.get());
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testResolve() {
        EventType inputEventType = new EventType();
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)ArgumentMatchers.eq((Object)this.childProcessor1), (EventType)ArgumentMatchers.any(EventType.class), (TypingMuleAstVisitorContext)ArgumentMatchers.eq((Object)this.visitorContext))).thenReturn((Object)inputEventType);
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)ArgumentMatchers.eq((Object)this.childProcessor2), (EventType)ArgumentMatchers.any(EventType.class), (TypingMuleAstVisitorContext)ArgumentMatchers.eq((Object)this.visitorContext))).thenReturn((Object)inputEventType);
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
        ((TypingMuleAstVisitor)Mockito.verify((Object)this.typingMuleAstVisitor)).resolveType((AstNode)ArgumentMatchers.eq((Object)this.childProcessor1), (EventType)ArgumentMatchers.any(EventType.class), (TypingMuleAstVisitorContext)ArgumentMatchers.eq((Object)this.visitorContext));
        ((TypingMuleAstVisitor)Mockito.verify((Object)this.typingMuleAstVisitor)).resolveType((AstNode)ArgumentMatchers.eq((Object)this.childProcessor2), (EventType)ArgumentMatchers.any(EventType.class), (TypingMuleAstVisitorContext)ArgumentMatchers.eq((Object)this.visitorContext));
        ((ErrorHandlingEnvironment)Mockito.verify((Object)this.errorHandlingEnvironment)).enterErrorHandling();
    }
}

