/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.RemoveVariableTypeResolver;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoveVariableTypeResolverTest {
    private RemoveVariableTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private ComponentAst componentModel;
    @Mock
    private ComponentParameterAst parameterAst;
    @Mock
    private Either<String, Object> parameterValue;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext visitorContext;

    @Before
    public void setup() {
        this.resolver = new RemoveVariableTypeResolver();
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.componentModel.getParameter("General", "variableName")).thenReturn((Object)this.parameterAst);
        Mockito.when((Object)this.parameterAst.getValue()).thenReturn(this.parameterValue);
        Mockito.when((Object)this.parameterValue.getRight()).thenReturn((Object)"testVar");
    }

    @Test
    public void testGetComponentModelType() {
        Optional componentModelType = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)componentModelType.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, componentModelType.get());
    }

    @Test
    public void testGetVarDeclName() {
        Optional varName = this.resolver.getVarDeclName(this.messageProcessorNode);
        Assert.assertTrue((boolean)varName.isPresent());
        Assert.assertEquals((Object)"testVar", varName.get());
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testResolve() {
        EventType inputEventType = new EventType();
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)ArgumentMatchers.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)ArgumentMatchers.any(DefinesTypeAnnotation.class)));
    }
}

