/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ScopeTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class ScopeTypeResolverTest {
    private ScopeTypeResolver scopeTypeResolver;
    private ComponentIdentifier scopeInIdentifier;
    private ComponentIdentifier scopeOutIdentifier;
    private ScopeTypeResolver.ScopeIn scopeIn;
    private ScopeTypeResolver.ScopeOut scopeOut;
    private MessageProcessorNode mockNode;
    private EventType mockEventType;
    private TypingMuleAstVisitor mockVisitor;
    private TypingMuleAstVisitorContext mockContext;

    @Before
    public void setUp() {
        this.scopeInIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.scopeOutIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.scopeTypeResolver = new TestScopeTypeResolver(this.scopeInIdentifier, this.scopeOutIdentifier);
        this.scopeIn = new ScopeTypeResolver.ScopeIn();
        this.scopeOut = new ScopeTypeResolver.ScopeOut();
        this.mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.mockEventType = (EventType)Mockito.mock(EventType.class);
        this.mockVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.mockContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testGetComponentIdentiferScopeIn() {
        Assert.assertEquals((Object)this.scopeInIdentifier, (Object)this.scopeTypeResolver.getComponentIdentiferScopeIn());
    }

    @Test
    public void testGetComponentIdentiferScopeOut() {
        Assert.assertEquals((Object)this.scopeOutIdentifier, (Object)this.scopeTypeResolver.getComponentIdentiferScopeOut());
    }

    @Test
    public void testGetComponentModelType() {
        Assert.assertEquals(Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE), (Object)this.scopeTypeResolver.getComponentModelType());
    }

    @Test
    public void testIsPropagates() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Assert.assertFalse((boolean)this.scopeTypeResolver.isPropagates(node));
    }

    @Test
    public void testIsScope() {
        Assert.assertTrue((boolean)this.scopeTypeResolver.isScope());
    }

    @Test
    public void testResolve() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        EventType inputEventType = (EventType)Mockito.mock(EventType.class);
        TypingMuleAstVisitor visitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        TypingMuleAstVisitorContext context = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)node.getMessageProcessorNodes()).thenReturn(Stream.of(childNode));
        EventType outputEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)visitor.resolveType((AstNode)childNode, inputEventType, context)).thenReturn((Object)outputEventType);
        EventType result = this.scopeTypeResolver.resolve(node, inputEventType, visitor, context);
        Assert.assertNotNull((Object)result);
        ((TypingMuleAstVisitor)Mockito.verify((Object)visitor)).resolveType((AstNode)childNode, inputEventType, context);
    }

    @Test
    public void testGetParseProvider() {
        Optional parseProvider = this.scopeTypeResolver.getParseProvider();
        Assert.assertTrue((boolean)parseProvider.isPresent());
    }

    @Test
    public void testGetScopeInMessageProcessorNode() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)node.getMessageProcessorNodes()).thenReturn(Stream.of(childNode));
        Mockito.when((Object)childNode.getComponentIdentifier()).thenReturn((Object)this.scopeInIdentifier);
        Optional result = this.scopeTypeResolver.getScopeInMessageProcessorNode(node);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)childNode, result.get());
    }

    @Test
    public void testGetScopeOutMessageProcessorNode() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)node.getMessageProcessorNodes()).thenReturn(Stream.of(childNode));
        Mockito.when((Object)childNode.getComponentIdentifier()).thenReturn((Object)this.scopeOutIdentifier);
        Optional result = this.scopeTypeResolver.getScopeOutMessageProcessorNode(node);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)childNode, result.get());
    }

    @Test
    public void testScopeInResolve() {
        MuleFlowAnnotation mockFlowAnnotation = (MuleFlowAnnotation)Mockito.mock(MuleFlowAnnotation.class);
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        UsesTypeAnnotation mockUsesTypeAnnotation = (UsesTypeAnnotation)Mockito.mock(UsesTypeAnnotation.class);
        EventType mockUsesEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)mockFlowAnnotation.getMuleFlowNode()).thenReturn((Object)muleFlowNode);
        Mockito.when((Object)muleFlowNode.getAnnotation(UsesTypeAnnotation.class)).thenReturn(Optional.of(mockUsesTypeAnnotation));
        Mockito.when((Object)mockUsesTypeAnnotation.getUsesEventType()).thenReturn((Object)mockUsesEventType);
        EventType result = this.scopeIn.resolve(this.mockNode, this.mockEventType, this.mockVisitor, this.mockContext);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testScopeInIsPropagates() {
        Assert.assertTrue((boolean)this.scopeIn.isPropagates((MessageProcessorNode)Mockito.mock(MessageProcessorNode.class)));
    }

    @Test
    public void testScopeOutResolve() {
        MuleFlowAnnotation mockFlowAnnotation = (MuleFlowAnnotation)Mockito.mock(MuleFlowAnnotation.class);
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        DefinesTypeAnnotation mockDefinesTypeAnnotation = (DefinesTypeAnnotation)Mockito.mock(DefinesTypeAnnotation.class);
        EventType mockDefinesEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(mockFlowAnnotation));
        Mockito.when((Object)mockFlowAnnotation.getMuleFlowNode()).thenReturn((Object)muleFlowNode);
        Mockito.when((Object)muleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.of(mockDefinesTypeAnnotation));
        Mockito.when((Object)mockDefinesTypeAnnotation.getDefinesEventType()).thenReturn((Object)mockDefinesEventType);
        EventType result = this.scopeOut.resolve(this.mockNode, this.mockEventType, this.mockVisitor, this.mockContext);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testScopeOutIsPropagates() {
        Assert.assertTrue((boolean)this.scopeOut.isPropagates(this.mockNode));
    }

    @Test
    public void testGenerateAst() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = ScopeTypeResolver.class.getDeclaredMethod("generateAst", ComponentIdentifier.class, ComponentAst.class, ComponentModelType.class, List.class);
        method.setAccessible(true);
        method.invoke((Object)this.scopeTypeResolver, Mockito.mock(ComponentIdentifier.class), Mockito.mock(ComponentAst.class), ComponentModelType.MESSAGE_PROCESSOR_NODE, Arrays.asList((MessageProcessorNodeBuilder)Mockito.mock(MessageProcessorNodeBuilder.class)));
    }

    private static class TestScopeTypeResolver
    extends ScopeTypeResolver {
        public TestScopeTypeResolver(ComponentIdentifier scopeIn, ComponentIdentifier scopeOut) {
            super(scopeIn, scopeOut);
        }
    }
}

