/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.UnknownProcessorTypeResolver;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class UnknownProcessorTypeResolverTest {
    private UnknownProcessorTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private ComponentAst componentModel;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext visitorContext;

    @Before
    public void setup() {
        this.resolver = new UnknownProcessorTypeResolver();
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
    }

    @Test
    public void testGetComponentModelType() {
        Optional componentModelType = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)componentModelType.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, componentModelType.get());
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testResolve() {
        EventType inputEventType = new EventType();
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result != inputEventType ? 1 : 0) != 0);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)ArgumentMatchers.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)ArgumentMatchers.any(DefinesTypeAnnotation.class)));
    }
}

