/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.batch;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchJobTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;

public class BatchJobTypeResolverTest {
    private BatchJobTypeResolver batchJobTypeResolver;
    private ComponentIdentifier mockScopeIn;
    private ComponentIdentifier mockScopeOut;
    private MessageProcessorNode mockMessageProcessorNode;
    private EventType mockInputEventType;
    private TypingMuleAstVisitor mockTypingMuleAstVisitor;
    private TypingMuleAstVisitorContext mockTypingMuleAstVisitorContext;

    @Before
    public void setUp() {
        this.mockScopeIn = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.mockScopeOut = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.batchJobTypeResolver = new BatchJobTypeResolver(this.mockScopeIn, this.mockScopeOut);
        this.mockMessageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.mockInputEventType = (EventType)Mockito.mock(EventType.class);
        this.mockTypingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.mockTypingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testResolve() {
        EventType mockMergedEventType = (EventType)Mockito.mock(EventType.class);
        EventType result = this.batchJobTypeResolver.resolve(this.mockMessageProcessorNode, this.mockInputEventType, this.mockTypingMuleAstVisitor, this.mockTypingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertNotEquals((Object)mockMergedEventType, (Object)result);
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.batchJobTypeResolver.isPropagates(this.mockMessageProcessorNode));
    }

    @Test
    public void testScopeInResolve() {
        BatchJobTypeResolver.ScopeIn scopeIn = new BatchJobTypeResolver.ScopeIn();
        EventType result = scopeIn.resolve(this.mockMessageProcessorNode, this.mockInputEventType, this.mockTypingMuleAstVisitor, this.mockTypingMuleAstVisitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertEquals((Object)this.mockInputEventType, (Object)result);
    }

    @Test
    public void testScopeInGenerateExpected() {
        BatchJobTypeResolver.ScopeIn scopeIn = new BatchJobTypeResolver.ScopeIn();
        EventType mockExpectedEventType = (EventType)Mockito.mock(EventType.class);
        ExpectedAstVisitor mockExpectedAstVisitor = (ExpectedAstVisitor)Mockito.mock(ExpectedAstVisitor.class);
        ExpectedAstVisitorContext mockVisitorContext = (ExpectedAstVisitorContext)Mockito.mock(ExpectedAstVisitorContext.class);
        Mockito.when((Object)mockVisitorContext.getExpectedEventType()).thenReturn((Object)mockExpectedEventType);
        EventType result = scopeIn.generateExpected(this.mockMessageProcessorNode, mockExpectedAstVisitor, mockVisitorContext);
        Assert.assertEquals((Object)mockExpectedEventType, (Object)result);
    }
}

