/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.tooling;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.FunctionBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.tooling.TypeInfoQuery;
import org.mule.runtime.api.component.location.Location;

@RunWith(value=MockitoJUnitRunner.class)
public class TypeInfoQueryTest {
    @Mock
    private MuleApplicationNode muleApplicationNode;
    @Mock
    private DataSenseProviderResolver dataSenseProviderResolver;
    @Mock
    private AstNotification astNotification;
    @Mock
    private Location location;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    private TypeInfoQuery typeInfoQuery;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.typeInfoQuery = new TypeInfoQuery(this.location);
    }

    @Test
    public void testPerformWithUsesTypeAndDefinesType() {
        UsesTypeAnnotation usesTypeAnnotation = (UsesTypeAnnotation)Mockito.mock(UsesTypeAnnotation.class);
        DefinesTypeAnnotation definesTypeAnnotation = (DefinesTypeAnnotation)Mockito.mock(DefinesTypeAnnotation.class);
        EventType usesEventType = new EventType();
        EventType definesEventType = new EventType();
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNode(this.location)).thenReturn(Optional.of(this.messageProcessorNode));
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(UsesTypeAnnotation.class)).thenReturn(Optional.of(usesTypeAnnotation));
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.of(definesTypeAnnotation));
        Mockito.when((Object)usesTypeAnnotation.getUsesEventType()).thenReturn((Object)usesEventType);
        Mockito.when((Object)definesTypeAnnotation.getDefinesEventType()).thenReturn((Object)definesEventType);
        Optional result = this.typeInfoQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull(result.get());
        Assert.assertNotNull(result.get());
    }

    @Test
    public void testPerformWithoutUsesTypeAndDefinesType() {
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNode(this.location)).thenReturn(Optional.of(this.messageProcessorNode));
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(UsesTypeAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.empty());
        Optional result = this.typeInfoQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull(result.get());
        Assert.assertNotNull(result.get());
    }

    @Test
    public void testPerformWithNoMessageProcessorNode() {
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNode(this.location)).thenReturn(Optional.empty());
        Optional result = this.typeInfoQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetGlobalTypeBindings() {
        GlobalBindingsAnnotation globalBindingsAnnotation = (GlobalBindingsAnnotation)Mockito.mock(GlobalBindingsAnnotation.class);
        Mockito.when((Object)this.muleApplicationNode.getAnnotation(GlobalBindingsAnnotation.class)).thenReturn(Optional.of(globalBindingsAnnotation));
        Map result = TypeInfoQuery.getGlobalTypeBindings((MuleApplicationNode)this.muleApplicationNode);
        Assert.assertNotNull((Object)result);
        Assert.assertSame(Collections.emptyMap(), (Object)result);
    }

    @Test
    public void testGetGlobalTypeBindingsWithNoAnnotation() {
        Mockito.when((Object)this.muleApplicationNode.getAnnotation(GlobalBindingsAnnotation.class)).thenReturn(Optional.empty());
        Map result = TypeInfoQuery.getGlobalTypeBindings((MuleApplicationNode)this.muleApplicationNode);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGetFunctionBindings() {
        FunctionBindingsAnnotation functionBindingsAnnotation = (FunctionBindingsAnnotation)Mockito.mock(FunctionBindingsAnnotation.class);
        Mockito.when((Object)this.muleApplicationNode.getAnnotation(FunctionBindingsAnnotation.class)).thenReturn(Optional.of(functionBindingsAnnotation));
        Map result = TypeInfoQuery.getFunctionBindings((MuleApplicationNode)this.muleApplicationNode);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Collections.emptyMap(), (Object)result);
    }

    @Test
    public void testGetFunctionBindingsWithNoAnnotation() {
        Mockito.when((Object)this.muleApplicationNode.getAnnotation(FunctionBindingsAnnotation.class)).thenReturn(Optional.empty());
        Map result = TypeInfoQuery.getFunctionBindings((MuleApplicationNode)this.muleApplicationNode);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

