/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.util.Utils;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class UtilsTest {
    @Test
    public void testSelectOptionalWithEmptyValues() {
        Supplier<Optional> empty1 = Optional::empty;
        Supplier<Optional> empty2 = Optional::empty;
        Optional result = Utils.selectOptional((Supplier[])new Supplier[]{empty1, empty2});
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testSelectOptionalWithMixedValues() {
        Supplier<Optional> empty = Optional::empty;
        Supplier<Optional> value = () -> Optional.of("test");
        Optional result1 = Utils.selectOptional((Supplier[])new Supplier[]{empty, value});
        Optional result2 = Utils.selectOptional((Supplier[])new Supplier[]{value, empty});
        Assert.assertTrue((boolean)result1.isPresent());
        Assert.assertEquals((Object)"test", result1.get());
        Assert.assertTrue((boolean)result2.isPresent());
        Assert.assertEquals((Object)"test", result2.get());
    }

    @Test
    public void testSelectOptionalWithAllValues() {
        Supplier<Optional> value1 = () -> Optional.of("first");
        Supplier<Optional> value2 = () -> Optional.of("second");
        Optional result = Utils.selectOptional((Supplier[])new Supplier[]{value1, value2});
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"first", result.get());
    }

    @Test
    public void testIsNullOrEmptyWithNull() {
        Assert.assertTrue((boolean)Utils.isNullOrEmpty(null));
    }

    @Test
    public void testIsNullOrEmptyWithEmptyString() {
        Assert.assertTrue((boolean)Utils.isNullOrEmpty((String)""));
    }

    @Test
    public void testIsNullOrEmptyWithNonEmptyString() {
        Assert.assertFalse((boolean)Utils.isNullOrEmpty((String)"test"));
    }
}

