/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.extension;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.extension.OperationModelTransform;
import org.mule.datasense.impl.util.extension.OutputModelTransform;
import org.mule.datasense.impl.util.extension.ParameterGroupModelTransform;
import org.mule.datasense.impl.util.extension.SourceCallbackModelTransform;
import org.mule.datasense.impl.util.extension.SourceModelTransform;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;

public class ExtensionTransformTest {
    private ExtensionModel extensionModel;
    private BaseTypeBuilder typeBuilder;

    @Before
    public void setUp() {
        this.typeBuilder = TypesHelper.getTypeBuilder();
        ExtensionModelLoader extensionModelLoader = new ExtensionModelLoader(){

            public String getId() {
                return null;
            }

            protected void declareExtension(ExtensionLoadingContext extensionLoadingContext) {
                ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
                extensionDeclarer.named("extension_transform_test");
                extensionDeclarer.onVersion("1.0");
                extensionDeclarer.fromVendor("test");
                extensionDeclarer.withCategory(Category.COMMUNITY);
                OperationDeclarer op1 = extensionDeclarer.withOperation("op1");
                op1.withOutput().ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                op1.withOutputAttributes().ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                ParameterGroupDeclarer op1g1 = op1.onParameterGroup("op1g1");
                op1g1.withRequiredParameter("op1g1p1").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                op1g1.withRequiredParameter("op1g1p2").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                ParameterGroupDeclarer op1g2 = op1.onParameterGroup("op1g2");
                op1g2.withRequiredParameter("op1g2p1").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                op1g2.withRequiredParameter("op1g2p2").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                SourceDeclarer sc1 = extensionDeclarer.withMessageSource("sc1");
                sc1.withOutput().ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                sc1.withOutputAttributes().ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                ParameterGroupDeclarer sc1g1 = sc1.onParameterGroup("sc1g1");
                sc1g1.withRequiredParameter("sc1g1p1").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                sc1g1.withRequiredParameter("sc1g1p2").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                ParameterGroupDeclarer sc1g2 = sc1.onParameterGroup("sc1g2");
                sc1g2.withRequiredParameter("sc1g2p1").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
                sc1g2.withRequiredParameter("sc1g2p2").ofType((MetadataType)ExtensionTransformTest.this.typeBuilder.stringType().build());
            }
        };
        this.extensionModel = extensionModelLoader.loadExtensionModel(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), Collections.emptyMap());
    }

    private Optional<ParameterModel> findParameterModel(ParameterizedModel parameterizedModel, String name) {
        return parameterizedModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(name)).findFirst();
    }

    private void parameterHasType(String parameter, ParameterizedModel parameterizedModel, Class<? extends MetadataType> expectedType) {
        ParameterModel parameterModel = this.findParameterModel(parameterizedModel, parameter).orElseThrow(AssertionError::new);
        Assert.assertThat((Object)parameterModel.getType(), (Matcher)IsInstanceOf.instanceOf(expectedType));
    }

    private void parameterTypeNotAffected(String parameter, ParameterizedModel parameterizedModel, ParameterizedModel oldParameterizedModel) {
        ParameterModel parameterModel = this.findParameterModel(parameterizedModel, parameter).orElseThrow(AssertionError::new);
        ParameterModel oldParameterModel = this.findParameterModel(oldParameterizedModel, parameter).orElseThrow(AssertionError::new);
        Assert.assertThat((Object)parameterModel.getType(), (Matcher)IsInstanceOf.instanceOf(oldParameterModel.getType().getClass()));
    }

    @Test
    public void anOperationSpecifiedParameterTypeShouldBeTransformed() {
        OperationModel operationModel = this.extensionModel.getOperationModels().stream().filter(operationModel1 -> operationModel1.getName().equals("op1")).findFirst().orElseThrow(RuntimeException::new);
        OperationModelTransform operationModelTransform = new OperationModelTransform(new ParameterGroupModelTransform(parameterModel -> {
            if (parameterModel.getName().equals("op1g1p1")) {
                return this.typeBuilder.numberType().build();
            }
            if (parameterModel.getName().equals("op1g2p1")) {
                return this.typeBuilder.numberType().build();
            }
            return parameterModel.getType();
        }), new OutputModelTransform(), new OutputModelTransform());
        OperationModel transformedOperationModel = operationModelTransform.transform(operationModel);
        this.parameterHasType("op1g1p1", (ParameterizedModel)transformedOperationModel, NumberType.class);
        this.parameterTypeNotAffected("op1g1p2", (ParameterizedModel)transformedOperationModel, (ParameterizedModel)operationModel);
        this.parameterHasType("op1g2p1", (ParameterizedModel)transformedOperationModel, NumberType.class);
        this.parameterTypeNotAffected("op1g2p2", (ParameterizedModel)transformedOperationModel, (ParameterizedModel)operationModel);
    }

    @Test
    public void anOperationOutputAndOutputAttributesTypesShouldBeTransformed() {
        OperationModel operationModel = this.extensionModel.getOperationModels().stream().filter(operationModel1 -> operationModel1.getName().equals("op1")).findFirst().orElseThrow(RuntimeException::new);
        OperationModelTransform operationModelTransform = new OperationModelTransform(new ParameterGroupModelTransform(), new OutputModelTransform(outputModel -> this.typeBuilder.numberType().build()), new OutputModelTransform(outputModel -> this.typeBuilder.booleanType().build()));
        OperationModel transformedOperationModel = operationModelTransform.transform(operationModel);
        Assert.assertThat((Object)transformedOperationModel.getOutput().getType(), (Matcher)IsInstanceOf.instanceOf(NumberType.class));
        Assert.assertThat((Object)transformedOperationModel.getOutputAttributes().getType(), (Matcher)IsInstanceOf.instanceOf(BooleanType.class));
    }

    @Test
    public void aSourceSpecifiedParameterTypeShouldBeTransformed() {
        SourceModel sourceModel = this.extensionModel.getSourceModels().stream().filter(sourceModel1 -> sourceModel1.getName().equals("sc1")).findFirst().orElseThrow(RuntimeException::new);
        SourceModelTransform sourceModelTransform = new SourceModelTransform(new ParameterGroupModelTransform(parameterModel -> {
            if (parameterModel.getName().equals("sc1g1p1")) {
                return this.typeBuilder.numberType().build();
            }
            if (parameterModel.getName().equals("sc1g2p1")) {
                return this.typeBuilder.numberType().build();
            }
            return parameterModel.getType();
        }), new OutputModelTransform(), new OutputModelTransform(), new SourceCallbackModelTransform(), new SourceCallbackModelTransform(), new SourceCallbackModelTransform());
        SourceModel sourceModelTransformed = sourceModelTransform.transform(sourceModel);
        this.parameterHasType("sc1g1p1", (ParameterizedModel)sourceModelTransformed, NumberType.class);
        this.parameterTypeNotAffected("sc1g1p2", (ParameterizedModel)sourceModelTransformed, (ParameterizedModel)sourceModel);
        this.parameterHasType("sc1g2p1", (ParameterizedModel)sourceModelTransformed, NumberType.class);
        this.parameterTypeNotAffected("sc1g2p2", (ParameterizedModel)sourceModelTransformed, (ParameterizedModel)sourceModel);
    }

    @Test
    public void aSourceOutputAndOutputAttributesTypesShouldBeTransformed() {
        SourceModel sourceModel = this.extensionModel.getSourceModels().stream().filter(sourceModel1 -> sourceModel1.getName().equals("sc1")).findFirst().orElseThrow(RuntimeException::new);
        SourceModelTransform sourceModelTransform = new SourceModelTransform(new ParameterGroupModelTransform(), new OutputModelTransform(outputModel -> this.typeBuilder.numberType().build()), new OutputModelTransform(outputModel -> this.typeBuilder.booleanType().build()), new SourceCallbackModelTransform(), new SourceCallbackModelTransform(), new SourceCallbackModelTransform());
        SourceModel sourceModelTransformed = sourceModelTransform.transform(sourceModel);
        Assert.assertThat((Object)sourceModelTransformed.getOutput().getType(), (Matcher)IsInstanceOf.instanceOf(NumberType.class));
        Assert.assertThat((Object)sourceModelTransformed.getOutputAttributes().getType(), (Matcher)IsInstanceOf.instanceOf(BooleanType.class));
    }
}

