/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.ast.api.ComponentAst;

public class AnnotatingMuleAstVisitorTest {
    @Mock
    private AnnotatorsRegistry annotatorsRegistry;
    @Mock
    private DataSenseProviderResolver dataSenseProviderResolver;
    @Mock
    private AstNotification astNotification;
    private AnnotatingMuleAstVisitor visitor;
    private AnnotatingMuleAstVisitorContext context;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.visitor = new AnnotatingMuleAstVisitor(this.annotatorsRegistry);
        this.context = new AnnotatingMuleAstVisitorContext(this.astNotification, this.dataSenseProviderResolver);
    }

    @Test
    public void testVisitMessageProcessorNode() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)node.getName()).thenReturn((Object)"testProcessor");
        Mockito.when((Object)node.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)node.getMessageProcessorNodes()).thenReturn(Arrays.asList(node).stream());
        this.visitor.visit(node, this.context);
        ((AnnotatorsRegistry)Mockito.verify((Object)this.annotatorsRegistry)).annotate(node, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)node)).getMessageProcessorNodes();
    }

    @Test
    public void testVisitRootMessageProcessorNode() {
        MessageProcessorNode rootNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)rootNode.getName()).thenReturn((Object)"rootProcessor");
        Mockito.when((Object)rootNode.isRootMessageProcessorNode()).thenReturn((Object)true);
        Mockito.when((Object)rootNode.getMessageProcessorNodes()).thenReturn(Collections.singletonList(childNode).stream());
        this.visitor.visit(rootNode, this.context);
        ((AnnotatorsRegistry)Mockito.verify((Object)this.annotatorsRegistry)).annotate(rootNode, this.context);
    }

    @Test
    public void testVisitMuleApplicationNode() {
        MuleApplicationNode node = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
        Mockito.when((Object)node.getName()).thenReturn((Object)"testApplication");
        this.visitor.visit(node, this.context);
        Assert.assertNotNull((Object)this.context);
    }

    @Test
    public void testVisitMuleFlowNode() {
        MuleFlowNode node = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        Mockito.when((Object)node.getName()).thenReturn((Object)"testFlow");
        MessageProcessorNode messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Metadata mockMetadata = (Metadata)Mockito.mock(Metadata.class);
        FunctionType functionType = (FunctionType)Mockito.mock(FunctionType.class);
        FunctionParameter functionParameter = (FunctionParameter)Mockito.mock(FunctionParameter.class);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        MessageProcessorTypeDeclaration messageProcessorTypeDeclaration = (MessageProcessorTypeDeclaration)Mockito.mock(MessageProcessorTypeDeclaration.class);
        Mockito.when((Object)node.getRootMessageProcessorNode()).thenReturn(Optional.of(messageProcessorNode));
        Mockito.when((Object)node.getName()).thenReturn((Object)"muleFlowNode");
        Mockito.when((Object)this.dataSenseProviderResolver.getApiKitMetadata()).thenReturn(Optional.of(mockMetadata));
        Mockito.when((Object)mockMetadata.getMetadataForFlow("muleFlowNode")).thenReturn(Optional.of(functionType));
        Mockito.when((Object)this.dataSenseProviderResolver.findMessageProcessorTypeDeclaration((ComponentAst)Mockito.any())).thenReturn(Optional.empty());
        Mockito.when((Object)node.getComponentModel()).thenReturn((Object)componentAst);
        Mockito.when((Object)componentAst.getLocation()).thenReturn((Object)componentLocation);
        Mockito.when((Object)componentLocation.getLocation()).thenReturn((Object)"${location1}");
        Mockito.when((Object)functionType.getParameters()).thenReturn(Arrays.asList(functionParameter));
        Mockito.when((Object)functionType.getReturnType()).thenReturn(Optional.of(metadataType));
        this.visitor.visit(node, this.context);
        ((MuleFlowNode)Mockito.verify((Object)node)).annotate((AstNodeAnnotation)((ComponentLocationAnnotation)Mockito.any(ComponentLocationAnnotation.class)));
    }

    @Test
    public void testAnnotateWithDataSenseProviderResolver() {
        AstNode astNode = (AstNode)Mockito.mock(AstNode.class);
        this.visitor.annotate(astNode, this.dataSenseProviderResolver, this.astNotification);
        ((AstNode)Mockito.verify((Object)astNode)).accept((AstNodeVisitor)Mockito.eq((Object)this.visitor), (Object)((AnnotatingMuleAstVisitorContext)Mockito.any(AnnotatingMuleAstVisitorContext.class)));
    }

    @Test
    public void testAnnotateWithContext() {
        AstNode astNode = (AstNode)Mockito.mock(AstNode.class);
        this.visitor.annotate(astNode, this.context);
        ((AstNode)Mockito.verify((Object)astNode)).accept((AstNodeVisitor)this.visitor, (Object)this.context);
    }
}

