/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.annotators.InfoAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

public class InfoAnnotatorTest {
    private InfoAnnotator infoAnnotator;
    @Mock
    private AnnotatingMuleAstVisitorContext mockContext;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private MuleApplicationAnnotation mockMuleApplicationAnnotation;
    @Mock
    private MuleFlowAnnotation mockMuleFlowAnnotation;
    @Mock
    private MuleApplicationNode mockMuleApplicationNode;
    @Mock
    private MuleFlowNode mockMuleFlowNode;
    @Mock
    private ComponentAst mockComponentModel;
    @Mock
    private ComponentLocation mockComponentLocation;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.infoAnnotator = new InfoAnnotator();
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"${location}");
    }

    @Test
    public void testAnnotateWithAllAnnotationsPresent() {
        Mockito.when((Object)this.mockContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(this.mockMuleApplicationAnnotation));
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(this.mockMuleFlowAnnotation));
        Mockito.when((Object)this.mockMuleApplicationAnnotation.getMuleApplicationNode()).thenReturn((Object)this.mockMuleApplicationNode);
        Mockito.when((Object)this.mockMuleFlowAnnotation.getMuleFlowNode()).thenReturn((Object)this.mockMuleFlowNode);
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.getLocation()).thenReturn((Object)this.mockComponentLocation);
        Mockito.when((Object)this.mockMessageProcessorNode.isSynthetic()).thenReturn((Object)false);
        this.infoAnnotator.annotate(this.mockMessageProcessorNode, this.mockContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((ComponentLocationAnnotation)Mockito.any(ComponentLocationAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)this.mockMuleFlowNode)).register(this.mockComponentLocation, this.mockMessageProcessorNode);
        ((MuleApplicationNode)Mockito.verify((Object)this.mockMuleApplicationNode)).register(this.mockComponentLocation, this.mockMessageProcessorNode);
    }

    @Test
    public void testAnnotateWithMissingMuleApplicationAnnotation() {
        Mockito.when((Object)this.mockContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.empty());
        this.infoAnnotator.annotate(this.mockMessageProcessorNode, this.mockContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((ComponentLocationAnnotation)Mockito.any(ComponentLocationAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)this.mockMuleFlowNode, (VerificationMode)Mockito.never())).register((ComponentLocation)Mockito.any(), (MessageProcessorNode)Mockito.any());
        ((MuleApplicationNode)Mockito.verify((Object)this.mockMuleApplicationNode, (VerificationMode)Mockito.never())).register((ComponentLocation)Mockito.any(), (MessageProcessorNode)Mockito.any());
    }

    @Test
    public void testAnnotateWithMissingMuleFlowAnnotation() {
        Mockito.when((Object)this.mockContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(this.mockMuleApplicationAnnotation));
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.empty());
        this.infoAnnotator.annotate(this.mockMessageProcessorNode, this.mockContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((ComponentLocationAnnotation)Mockito.any(ComponentLocationAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)this.mockMuleFlowNode, (VerificationMode)Mockito.never())).register((ComponentLocation)Mockito.any(), (MessageProcessorNode)Mockito.any());
        ((MuleApplicationNode)Mockito.verify((Object)this.mockMuleApplicationNode, (VerificationMode)Mockito.never())).register((ComponentLocation)Mockito.any(), (MessageProcessorNode)Mockito.any());
    }

    @Test
    public void testAnnotateWithSyntheticMessageProcessor() {
        Mockito.when((Object)this.mockContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.of(this.mockMuleApplicationAnnotation));
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(this.mockMuleFlowAnnotation));
        Mockito.when((Object)this.mockMuleApplicationAnnotation.getMuleApplicationNode()).thenReturn((Object)this.mockMuleApplicationNode);
        Mockito.when((Object)this.mockMuleFlowAnnotation.getMuleFlowNode()).thenReturn((Object)this.mockMuleFlowNode);
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.getLocation()).thenReturn((Object)this.mockComponentLocation);
        Mockito.when((Object)this.mockMessageProcessorNode.isSynthetic()).thenReturn((Object)true);
        this.infoAnnotator.annotate(this.mockMessageProcessorNode, this.mockContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockMessageProcessorNode)).annotate((AstNodeAnnotation)((ComponentLocationAnnotation)Mockito.any(ComponentLocationAnnotation.class)));
        ((MuleFlowNode)Mockito.verify((Object)this.mockMuleFlowNode, (VerificationMode)Mockito.never())).register((ComponentLocation)Mockito.any(), (MessageProcessorNode)Mockito.any());
        ((MuleApplicationNode)Mockito.verify((Object)this.mockMuleApplicationNode, (VerificationMode)Mockito.never())).register((ComponentLocation)Mockito.any(), (MessageProcessorNode)Mockito.any());
    }
}

