/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMapping;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.runtime.api.meta.model.error.ErrorModel;

@RunWith(value=MockitoJUnitRunner.class)
public class ErrorMappingTest {
    @Mock
    private ErrorMatcher mockErrorMatcher;
    @Mock
    private ErrorModel mockErrorModel;

    @Test
    public void testConstructorAndGetters() {
        ErrorMapping errorMapping = new ErrorMapping(this.mockErrorMatcher, this.mockErrorModel);
        Assert.assertEquals((Object)this.mockErrorModel, (Object)errorMapping.getErrorModel());
    }

    @Test
    public void testMatches() {
        ErrorMapping errorMapping = new ErrorMapping(this.mockErrorMatcher, this.mockErrorModel);
        ErrorModel testErrorModel = (ErrorModel)Mockito.mock(ErrorModel.class);
        Mockito.when((Object)this.mockErrorMatcher.matches(testErrorModel)).thenReturn((Object)true);
        Assert.assertTrue((boolean)errorMapping.matches(testErrorModel));
        ((ErrorMatcher)Mockito.verify((Object)this.mockErrorMatcher)).matches(testErrorModel);
    }

    @Test
    public void testCreateWithValidInput() {
        String sourceType = "sourceType";
        String targetType = "targetType";
        Optional result = ErrorMapping.create((String)sourceType, (String)targetType);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull((Object)((ErrorMapping)result.get()).getErrorModel());
    }

    @Test
    public void testCreateWithNullSourceType() {
        String sourceType = null;
        String targetType = "targetType";
        Optional result = ErrorMapping.create(sourceType, (String)targetType);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCreateWithEmptySourceType() {
        String sourceType = "";
        String targetType = "targetType";
        Optional result = ErrorMapping.create((String)sourceType, (String)targetType);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCreateWithNullTargetType() {
        String sourceType = "sourceType";
        String targetType = null;
        Optional result = ErrorMapping.create((String)sourceType, targetType);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCreateWithEmptyTargetType() {
        String sourceType = "sourceType";
        String targetType = "";
        Optional result = ErrorMapping.create((String)sourceType, (String)targetType);
        Assert.assertFalse((boolean)result.isPresent());
    }
}

