/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.reporting;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.i18n.I18nMessage;

public class NotificationMessagesTest {
    @Test
    public void testMsgScriptingLanguageError() {
        String expression = "test expression";
        String reason = "test reason";
        I18nMessage result = NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR((String)expression, (String)reason);
        Assert.assertEquals((Object)"Scripting language error on expression 'test expression'. Reason: test reason.", (Object)result.getMessage());
    }

    @Test
    public void testMsgScriptingLanguageWarning() {
        String expression = "test expression";
        String reason = "test reason";
        I18nMessage result = NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING((String)expression, (String)reason);
        Assert.assertEquals((Object)"Scripting language warning on expression 'test expression'. Reason: test reason.", (Object)result.getMessage());
    }

    @Test
    public void testMsgResourceNotFound() {
        String resource = "test.xml";
        I18nMessage result = NotificationMessages.MSG_RESOURCE_NOT_FOUND((String)resource);
        Assert.assertEquals((Object)"Resource 'test.xml' not found.", (Object)result.getMessage());
    }

    @Test
    public void testMsgUnknownFlowComponent() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)node.getIdentifier()).thenReturn((Object)((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)));
        I18nMessage result = NotificationMessages.MSG_UNKNOWN_FLOW_COMPONENT((MessageProcessorNode)node);
        Assert.assertNotEquals((Object)"Unknown message processor testIdentifier. Datasense will use passthrough semantics.", (Object)result.getMessage());
    }

    @Test
    public void testMsgRamlResolutionNotification() {
        String notificationType = "INFO";
        String message = "RAML parsed successfully";
        I18nMessage result = NotificationMessages.MSG_RAML_RESOLUTION_NOTIFICATION((String)notificationType, (String)message);
        Assert.assertEquals((Object)"Raml resolution INFO: RAML parsed successfully.", (Object)result.getMessage());
    }

    @Test
    public void testMsgSoapkitResolutionNotification() {
        String notificationType = "WARNING";
        String message = "WSDL parsing issue";
        I18nMessage result = NotificationMessages.MSG_SOAPKIT_RESOLUTION_NOTIFICATION((String)notificationType, (String)message);
        Assert.assertEquals((Object)"SoapKit resolution WARNING: WSDL parsing issue.", (Object)result.getMessage());
    }

    @Test
    public void testMsgRamlResolutionInitialization() {
        String message = "Failed to load RAML file";
        I18nMessage result = NotificationMessages.MSG_RAML_RESOLUTION_INITIALIZATION((String)message);
        Assert.assertEquals((Object)"Raml resolution initialization failed. Error: Failed to load RAML file.", (Object)result.getMessage());
    }

    @Test
    public void testMsgSoapkitResolutionInitialization() {
        String message = "Invalid WSDL format";
        I18nMessage result = NotificationMessages.MSG_SOAPKIT_RESOLUTION_INITIALIZATION((String)message);
        Assert.assertEquals((Object)"SoapKit resolution initialization failed. Error: Invalid WSDL format.", (Object)result.getMessage());
    }

    @Test
    public void testMsgRecursiveCallDetected() {
        String flow = "myFlow";
        I18nMessage result = NotificationMessages.MSG_RECURSIVE_CALL_DETECTED((String)flow);
        Assert.assertEquals((Object)"Failed to infer output type on flow 'myFlow'. It is required to define output type on flows with recursive calls.", (Object)result.getMessage());
    }

    @Test
    public void testMsgDynamicMetadataResolutionSkippedCauseIncompleteParameters() {
        List<String> parameters = Arrays.asList("param1", "param2");
        I18nMessage result = NotificationMessages.MSG_DYNAMIC_METADATA_RESOLUTION_SKIPPED_CAUSE_INCOMPLETE_PARAMETERS(parameters);
        Assert.assertEquals((Object)"Dynamic metadata resolution skipped, missing parameters: param1,param2.", (Object)result.getMessage());
    }
}

